<?php
/* @var $this PageController */
/* @var $model Page */
/* @var $form CActiveForm */

$baseUrl = Yii::app()->baseUrl; 
$cs = Yii::app()->getClientScript();
$cs->registerScriptFile($baseUrl.'/js/fancybox/jquery.fancybox.pack.js');
$cs->registerCssFile($baseUrl.'/js/fancybox/jquery.fancybox.css');
$cs->registerScript('fancybox', '
jQuery(document).ready(function() {
	jQuery("a#inline").fancybox({
				"hideOnContentClick": false,
				"overlayColor"		: "#000",
				"overlayOpacity"	: "0.45"
			});
});'
);


?>


<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm', array(
				'id' => 'horizontalForm',
				'type' => 'vertical',
				'htmlOptions' => array('enctype' => 'multipart/form-data'),
			)); ?>

	<div class="row-fluid">
	<div class="span6">

	<h2><?php if($id) {?> Update Course <?php } else { ?>Create Course<?php } ?></h2>

	<div class="admin_form">

		


			<?php echo $form->errorSummary($model); ?>


			<div class="form-group">
				<?php echo $form->labelEx($model,'name'); ?>
				<?php echo $form->textField($model,'name',array('size'=>60,'maxlength'=>100)); ?>
				<?php echo $form->error($model,'name'); ?>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'essay_question'); ?>
				<?php echo $form->dropDownList($model, 'essay_question', array(NULL=>'No', 1=>'Yes')); ?>
				<?php echo $form->error($model,'essay_question'); ?>
			</div>

			<div class="form-group extra-padding">
				<?php 
				echo $form->redactorRow(
					$model,
					'short_description',
					array(
						'editorOptions' => array(
							'class' => 'span4', 
							'rows' => 5, 
							'height' => '200',
							'options' => array('plugins' => array('clips', 'fontfamily'), 'lang' => 'sv')
							)
						)
					); 
					?>
				<?php echo $form->error($model,'short_description'); ?>
			</div>

			<div class="form-group extra-padding">
				<?php 
				echo $form->redactorRow(
					$model,
					'description',
					array(
						'editorOptions' => array(
							'class' => 'span4', 
							'rows' => 5, 
							'height' => '200',
							'options' => array('plugins' => array('clips', 'fontfamily'), 'lang' => 'sv')
							)
						)
					); 
					?>
				<?php echo $form->error($model,'description'); ?>
			</div>


			<div class="form-group toggle" style="margin:15px 0;">
				<p>In person or Online</p>
				<?php 
				echo $form->toggleButtonRow($model, 'in_person', 
					array(
						'enabledLabel' => 'In Person',
						'disabledLabel' => 'Online',
						'width' => 150
						)
					); 
				?>
				<br>
				<small>(In person courses will not be visible to students in the online portal)</small>
			</div>

			

			<div class="form-group">
				Required within <?php echo $form->textField($model,'required_within_time',array('class'=>'small', 'maxlength'=>3)); ?> days of hiring
				<?php echo $form->error($model,'required_within_time'); ?>
			</div>

			<div class="form-group">
				Required every <?php echo $form->textField($model,'frequency_required',array('class'=>'small', 'maxlength'=>3)); ?> days
				<?php echo $form->error($model,'frequency_required'); ?>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'passing_percentage'); ?>
				<?php echo $form->textField($model,'passing_percentage',array('size'=>45,'maxlength'=>100)); ?>
				<?php echo $form->error($model,'passing_percentage'); ?>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'cost'); ?>
				<?php echo $form->textField($model,'cost',array('size'=>20,'maxlength'=>100)); ?>
				<?php echo $form->error($model,'cost'); ?>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'ceu_credit'); ?>
				<?php echo $form->textField($model,'ceu_credit',array('size'=>20,'maxlength'=>100)); ?>
				<?php echo $form->error($model,'ceu_credit'); ?>	
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'promo_code'); ?>
				<?php echo $form->textField($model,'promo_code',array('size'=>20,'maxlength'=>100)); ?>
				<?php echo $form->error($model,'promo_code'); ?>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'instruction_methods'); ?>
				<?php echo $form->textArea($model,'instruction_methods',array('rows'=>4, 'cols'=>50)); ?>
				<?php echo $form->error($model,'instruction_methods'); ?>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'course_categories'); ?>
				<ul class="option">
				<?php foreach($categories as $category) {  ?>
					
					<li>
						<?php echo CHtml::checkBox(
							'course_category['.$category->id.']', 
							$this->isChecked($id, $category->id) ? true : false, 
							array(
								'value'=>$category->id,
								'uncheckValue'=>'N'
							)); 
						?>

							<span><?php echo $category->name; ?></span>
						</li>

				<?php } ?>
				</ul>
			</div>

			<div class="form-group">
				<?php echo $form->labelEx($model,'video'); ?>
				<?php echo $form->textField($model,'video',array('size'=>60,'maxlength'=>300)); ?>
				<?php echo $form->error($model,'video'); ?>
			</div>

			<?php if($model->isNewRecord) { ?>

				<p>Please create the course before uploading files</p>

			<?php } else { ?>

				<div class="form-group file">
					<?php echo $form->labelEx($model,'powerpoint'); ?>
					<?php echo $form->fileField($model, 'powerpoint'); ?>
					<?php echo $form->error($model,'powerpoint'); ?>

					<?php if($model->powerpoint) { ?>
					<div class="listfile">
						<strong>Current File:</strong>
						<?php echo $model->powerpoint; ?> | 
						<?php echo CHtml::link('Delete', array('course/deletepowerpoint/'.$id),array()); ?>
					</div>
					<?php } ?>
				</div>
		
				<div class="form-group file">
					<?php echo $form->fileField($model, 'powerpoint_2'); ?>
					<?php echo $form->error($model,'powerpoint_2'); ?>

					<?php if($model->powerpoint_2) { ?>
					<div class="listfile">
						<strong>Current File:</strong>
						<?php echo $model->powerpoint_2; ?> | 
						<?php echo CHtml::link('Delete', array('course/deletepowerpoint/'.$id.'?version=2'),array()); ?>
					</div>
					<?php } ?>
				</div>

				<div class="form-group file">
					<?php echo $form->labelEx($model, 'syllabus'); ?>
					<?php echo $form->fileField($model, 'syllabus'); ?>
					<?php echo $form->error($model,'syllabus'); ?>

					<?php if($model->syllabus) { ?>
					<div class="listfile">
						<strong>Current File:</strong>
						<?php echo $model->syllabus; ?> | 
						<?php echo CHtml::link('Delete', array('course/deletepowerpoint/'.$id.'?version=3'),array()); ?>
					</div>
					<?php } ?>
				</div>
			


				<div class="form-group file">
					<?php echo $form->labelEx($model,'study_guide'); ?>
					<?php echo $form->fileField($model, 'study_guide'); ?>
					<?php echo $form->error($model,'study_guide'); ?>

					<?php if($model->study_guide) { ?>
					<div class="listfile">
						<strong>Current File:</strong>
						<?php echo $model->study_guide; ?> | 
						<?php echo CHtml::link('Delete', array('course/deletestudyguide/'.$id),array()); ?>
					</div>
					<?php } ?>
				</div>

				<div class="form-group file">
					<?php echo $form->fileField($model, 'study_guide_2'); ?>
					<?php echo $form->error($model,'study_guide_2'); ?>

					<?php if($model->study_guide_2) { ?>
					<div class="listfile">
						<strong>Current File:</strong>
						<?php echo $model->study_guide_2; ?> | 
						<?php echo CHtml::link('Delete', array('course/deletestudyguide/'.$id.'?version=2'),array()); ?>
					</div>
					<?php } ?>
				</div>

				<div class="form-group file">
					<?php echo $form->labelEx($model,'case_study'); ?>
					<?php echo $form->fileField($model, 'case_study'); ?>
					<?php echo $form->error($model,'case_study'); ?>

					<?php if($model->case_study) { ?>
					<div class="listfile">
						<strong>Current File:</strong>
						<?php echo $model->case_study; ?> | 
						<?php echo CHtml::link('Delete', array('course/deletestudyguide/'.$id.'?version=3'),array()); ?>
					</div>
					<?php } ?>
				</div>

			<?php } //End check if creation form ?>
			


			<div class="form-group buttons">
				<?php $this->widget(
					'bootstrap.widgets.TbButton',
					array(
						'buttonType' => 'submit',
						'type' => 'primary',
						'label' => $model->isNewRecord ? 'Create' : 'Save'
						)
					); 
					?>
			</div>

			

	</div><!-- admin-form -->
	</div>

	<div class="span5">
	<div id="questions">
		<h2>Add / Edit Questions</h2>

	<?php if($id) { ?>
		
		

		<div class="essay-question" style="<?php if($model->essay_question != 1) : ?>display:none<?php endif;?>">
			
			<div class="form-group">
				<?php echo $form->labelEx($model,'essay_question_content'); ?>
				<?php echo $form->textArea($model,'essay_question_content',array('rows'=>4, 'cols'=>80)); ?>
				<?php echo $form->error($model,'essay_question_content'); ?>
			</div>

			<div class="form-group buttons">
				<?php $this->widget(
					'bootstrap.widgets.TbButton',
					array(
						'buttonType' => 'submit',
						'type' => 'primary',
						'label' => $model->isNewRecord ? 'Create' : 'Save Essay Question'
						)
					); 
					?>
			</div>

		</div>		
		

		<div class="multiple-choice">

			<?php $this->widget(
				'bootstrap.widgets.TbExtendedGridView',
				array(
					'id'=>'question-grid',
					'fixedHeader' => false,
	        		// 'filter'=>$model,
					'headerOffset' => 40,
					'type' => 'striped bordered',
					'dataProvider' => $questions->getQuestions($id),
					'responsiveTable' => true,
					'template' => "{items}",
					'columns'=>array(
						array(
							'header'=>'Question',
							'name'=>'content',
							'value'=>'$data->content',
							),

						array(
							'class'=>'CButtonColumn',
						// 'template'=>'{up}{down}{delete}',
							'deleteButtonUrl'=>'Yii::app()->createUrl("question/delete/", array("id" => $data->id))',
							'buttons'=>array(
								'view'=> array('visible'=>'false'),
								'update' => array(
								    'label'=>'Update',     //Text label of the button.
								    'url'=> '$data->id',       //A PHP expression for generating the URL of the button.
								    'click' => 'function(){updateQuestion($(this).attr("href")); return false;}',
								    ),
								),
							),
						),

	        		// 'columns' => $gridColumns,
					)
				);
		?>

			

			<a href="#question_add" class="btn btn-primary inline add" id="inline">Add Question</a>

			
			


		</div> <!-- multiple-choice -->


		<?php } else { ?>

			<em>Please save the course before adding questions</em>

		<?php } ?>

	</div> <!-- Questions -->
	</div>
	</div>

<?php $this->endWidget(); ?>






<!-- Add Question Lightbox -->

			<div style="display:none">
				<div id="question_add">
					
					<?php 
						$form=$this->beginWidget('CActiveForm', array(
							'id'=>'question_form',
							'enableAjaxValidation'=>false,
							'htmlOptions'=>array(
								'onsubmit'=>"return false;", /* Disable normal form submit */
								),
							)); 
					?>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'content'); ?>
						<?php echo $form->textArea($questions,'content', array('placeholder'=>'Question')); ?>
						<?php echo $form->error($questions,'content'); ?>
					</div>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'Response Option A'); ?>
						<?php echo CHtml::radioButton('correct_answer', false, array('value'=>'1','uncheckValue'=>null)); ?> Correct Answer?
						<?php echo CHtml::textField('Option[a]', false, array('placeholder'=>'Option A')); ?>
					</div>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'Response Option B'); ?>
						<?php echo CHtml::radioButton('correct_answer', false, array('value'=>'2', 'uncheckValue'=>null)); ?> Correct Answer?
						<?php echo CHtml::textField('Option[b]', false, array('placeholder'=>'Option B')); ?>
					</div>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'Response Option C'); ?>
						<?php echo CHtml::radioButton('correct_answer', false, array('value'=>'3','uncheckValue'=>null)); ?> Correct Answer?
						<?php echo CHtml::textField('Option[c]', false, array('placeholder'=>'Option C')); ?>
					</div>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'Response Option D'); ?>
						<?php echo CHtml::radioButton('correct_answer', false, array('value'=>'4','uncheckValue'=>null)); ?> Correct Answer?
						<?php echo CHtml::textField('Option[d]', false, array('placeholder'=>'Option D')); ?>
					</div>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'Response Option E'); ?>
						<?php echo CHtml::radioButton('correct_answer', false, array('value'=>'5','uncheckValue'=>null)); ?> Correct Answer?
						<?php echo CHtml::textField('Option[e]', false, array('placeholder'=>'Option E')); ?>
					</div>

					<div class="form-group">
						<?php echo $form->labelEx($questions,'Response Option F'); ?>
						<?php echo CHtml::radioButton('correct_answer', false, array('value'=>'6','uncheckValue'=>null)); ?> Correct Answer?
						<?php echo CHtml::textField('Option[f]', false, array('placeholder'=>'Option F')); ?>
					</div>

					<div class="form-group buttons">
						<?php echo $form->hiddenField($questions,'course_id',array('type'=>"hidden",'size'=>2,'maxlength'=>2, 'value'=>$id)); ?>
						<?php echo CHtml::Button('Submit',array('onclick'=>'send();', 'class'=>'btn btn-primary')); ?> 
					</div>
					
					<?php $this->endWidget(); ?>

				</div>
			</div> <!-- Add Question Lightbox -->



			<script type="text/javascript">

				function send()
				{

					var data=$("#question_form").serialize();


					$.ajax({
						type: 'POST',
						url: '<?php echo Yii::app()->createAbsoluteUrl("course/AjaxQuestion"); ?>',
						data:data,
						success:function(data){
							$.fn.yiiGridView.update('question-grid');
							$.fancybox.close();
						},
					   error: function(data) { // if error occured
					   	alert("Error occured.please try again");
					   	//alert(data);
					   },

					   dataType:'html'
					});

				}


				function updateQuestion(question_id) {
					
					var url = '<?php echo Yii::app()->createAbsoluteUrl("course/updatequestion"); ?>/'+question_id;

					$.fancybox.open({
						'autoDimensions' : false,
						'type': 'iframe', 
						// 'maxHeight' : 670,
						'maxWidth' : 500,
						'scrolling' :'no',
						'autoScale' : false,
						'href' : url
					});

					


					return false;
				}



				$(document).ready(function() {
					$("#Course_essay_question").change(function() {
						var option = $(this).val();
						if (option == 1) {
							// $(".multiple-choice").hide();
							$(".essay-question").show();
						} else {
							// $(".multiple-choice").show();
							$(".essay-question").hide();
						} 
					});
				});


			</script>


