<?php
/* @var $this UserController */
/* @var $model User */
/* @var $form CActiveForm */




$baseUrl = Yii::app()->baseUrl; 
$cs = Yii::app()->getClientScript();
$cs->registerScriptFile($baseUrl.'/js/fancybox/jquery.fancybox.pack.js');
$cs->registerCssFile($baseUrl.'/js/fancybox/jquery.fancybox.css');
$cs->registerScript('fancybox', '
jQuery(document).ready(function() {
	jQuery("a#inline").fancybox({
				"hideOnContentClick": false,
				"overlayColor"		: "#000",
				"overlayOpacity"	: "0.45"
			});

	jQuery(".datepicker input").datepicker({"language":"en"});

});'
);


?>
	

<div class="span9">

<?php if(!$model->isNewRecord) {?>
<h2>Update User <?php echo ucfirst($model->fname) ?> <?php echo ucfirst($model->lname) ?></h2>
<?php } else { ?>
<h2>Create User</h2>
<?php } ?>


<div class="form">

<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm', array(
				'id' => 'horizontalForm',
				'type' => 'vertical',
				)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>

	<div class="form-group toggle">
		<?php echo $form->toggleButtonRow($model, 'active', 
			array(
				'enabledLabel' => 'Active',
				'disabledLabel' => 'Inactive',
				'width' => 150
				)
			); 
        ?>
	</div>

	<div class="form-group">
		<div class="row-fluid">
			<div class="span4">
				<?php echo $form->labelEx($model,'fname'); ?>
				<?php echo $form->textField($model,'fname',array('class'=>'full')); ?>
				<?php echo $form->error($model,'fname'); ?>
			</div>

			<div class="span4">
				<?php echo $form->labelEx($model,'lname'); ?>
				<?php echo $form->textField($model,'lname',array('class'=>'full')); ?>
				<?php echo $form->error($model,'lname'); ?>
			</div>
		</div>
	</div>

	<?php if (Yii::app()->user->access_level == 1): ?>	
	<div class="form-group">
		<?php echo $form->labelEx($model,'access_level'); ?>
		<?php echo $form->dropDownList($model, 'access_level', array(0=>'Student', 1=>'Admin', 2=>'Facility Admin')); ?>
		<?php echo $form->error($model,'access_level'); ?>
	</div>
	<?php endif ?>


	<div class="form-group">
		<?php echo $form->labelEx($model,'email'); ?>
		<?php echo $form->textField($model,'email',array('size'=>60,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'email'); ?>
	</div>

	<div class="form-group">
		<div class="row-fluid">
		<div class="span3">
			<?php echo $form->labelEx($model,'birthdate_month'); ?>
			<?php echo $form->textField($model,'birthdate_month',array('class'=>'full')); ?>
			<?php echo $form->error($model,'birthdate_month'); ?>
		</div>

		<div class="span3">
			<?php echo $form->labelEx($model,'birthdate_day'); ?>
			<?php echo $form->textField($model,'birthdate_day',array('class'=>'full')); ?>
			<?php echo $form->error($model,'birthdate_day'); ?>
		</div>

		<div class="span3">
			<?php echo $form->labelEx($model,'birthdate_year'); ?>
			<?php echo $form->textField($model,'birthdate_year',array('class'=>'full')); ?>
			<?php echo $form->error($model,'birthdate_year'); ?>
		</div>
		</div>
	</div>

	
	<?php if(!$model->isNewRecord) {?>

	<div class="form-group">
		<?php echo $form->labelEx($model,'passUpdate'); ?>
		<?php echo $form->passwordField($model,'passUpdate',array('size'=>60,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'passUpdate'); ?>
	</div>

	<?php } else { ?>


	<div class="form-group">
		<?php echo $form->labelEx($model,'pass'); ?>
		<?php echo $form->passwordField($model,'pass',array('size'=>60,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'pass'); ?>
	</div>

	<?php } ?>


	<div class="form-group">
		<?php echo $form->labelEx($model,'hired_date'); ?>
		<?php
			$this->widget(
			'bootstrap.widgets.TbDatePicker',
			array(
				'model' => $model,
				'attribute' => 'hired_date',
				'options' => array(
					// array('format' => 'yyyy-mm-dd';
					)
				)
			);
		?>
		<?php echo $form->error($model,'hired_date'); ?>
	</div>

	<div class="form-group">
		<?php echo $form->labelEx($model,'CEU_count'); ?>
		<?php echo $form->textField($model,'CEU_count'); ?>
		<?php echo $form->error($model,'CEU_count'); ?>
	</div>

	

	<?php /*if(!$model->isNewRecord) {?>

	<div class="form-group">
		<?php echo $form->labelEx($model,'course_categories'); ?>
		<ul class="option">
			<?php foreach($categories as $category) {  ?>
	
			<li>
				<?php 
					echo CHtml::checkBox(
					'staff_type['.$category->id.']', 
					in_array($category->id, $model->staff_type) ? true : false, 
					array(
						'value'=>$category->id,
						// 'uncheckValue'=>'N'
						)); 
				?>

						<span><?php echo $category->name; ?></span>
					</li>

				<?php } ?>
			</ul>
	</div>
	<?php } */ ?>

	
	<div class="form-group buttons">
		<?php echo $form->hiddenField($model,'access_code'); ?>
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save', array('class'=>'btn btn-primary')); ?>
		<!-- 'class'=>'btn btn-primary' -->
	</div>


<?php $this->endWidget(); ?>

</div><!-- form -->



<?php if(!$model->isNewRecord) {?>




<div class="row-fluid">
	<div class="span6">
		<h3>Courses</h3>
	</div>

	<!-- <div class="span6 text-right">
		<br>
		<a href="<?= Yii::app()->baseUrl; ?>/account/exportuserreport/<?= $model->id; ?>" class="btn btn-primary">Export User Report</a>
	</div> -->
</div>


<table class="table">
	<tr>
		<th>Course Name</th>
		<th>Status</th>
		<th></th>
	</tr>
<?php 
	foreach ($courseModel as $key => $course) {
		
		 $results = UserCourseAccess::checkStatus($course->id, $model->id);

		 $compliance = User::checkCompliance($model->id, $course->id);

		 // Get course progress model
		 $courseProgressModel=UserCourseAccess::model()->find(array(
			 	'condition'=>'user_id=:user_id AND course_id=:course_id',
			 	'params'=>array(':user_id'=>$model->id, ':course_id'=>$course->id),
		 	));

		 // If they haven't taken course, create new course progress model
		 if(!$courseProgressModel) {
		 	$courseProgressModel=new UserCourseAccess;
		 }
		 

		 // echo '<pre>';
		 // var_dump($compliance);
		 // echo '</pre>';

		 

?>
	<tr class="
		<?php 
			if($results['status'] == 'Completed' && $compliance['compliant'] != 0) {echo 'success';}
			if($results['status'] == 'In Progress') {echo 'warning';}
			if(isset($compliance) && $compliance['compliant'] != 1) {echo 'error';}
		?>
	">
		<td>
		 	<?php echo $course->name; ?>
		</td>
		<td>
			<!-- <a href="#course<?php echo $course->id; ?>" id="inline"><i class="icon-edit"></i></a>&nbsp; -->

			<?php 
				if($results['status'] == '') {
					echo 'Not Taken';
				} else {
					echo $results['status'];
				} 
			?>
			
			<?php 
			 if($results['time_completed']) {
			 	echo '- '.date('m/d/y', $results['time_completed']);
			 ?>
			
			<small><small><a target="_blank" href="/course_assets/certificates/<?php echo $course->getCertificateFilename($model->id); ?>">Download Certificate</a></small></small>

			 <?php } ?>

			 <?php if ($course->essay_question): ?>
				&nbsp;&nbsp;<small><a href="#essay<?php echo $course->id; ?>" id="inline">Add Essay Grade</a></small>&nbsp;&nbsp;

				<!-- Essay completion lightbox -->
				<div style="display:none;">
					<div id="essay<?php echo $course->id; ?>">
						<div class="manual_course_completion">
							<h4>Essay grade for <?php echo $course->name; ?></h4>
							<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm', array(
								'id' => 'horizontalForm',
								'type' => 'vertical',
								)); ?>											
									
								<div class="form-group">										
									<?php echo $form->dropDownList($courseProgressModel, 'essay_grade', array(NULL=>'Select', 1=>'Passed')); ?>
									<?php echo $form->error($courseProgressModel,'essay_grade'); ?>
								</div>

								<div class="form-group buttons">
									<!-- <input type="hidden" name="UserCourseAccess[status]" value="Completed"/> -->
									<input type="hidden" name="UserCourseAccess[course_id]" value="<?php echo $course->id; ?>"/>
									<?php echo $form->hiddenField($courseProgressModel,'id'); ?>
									<?php echo CHtml::submitButton($courseProgressModel->isNewRecord ? 'Create' : 'Save', array('class'=>'btn btn-primary')); ?>
									<!-- 'class'=>'btn btn-primary' -->
								</div>

								<?php $this->endWidget(); ?>
						</div>
					</div>
				</div>
				<!-- End manual completion lightbox -->

			<?php endif ?>
			 
			<!-- Manual completion lightbox -->
			<div style="display:none;">
				<div id="course<?php echo $course->id; ?>">
					<div class="manual_course_completion">
						<h4>Add/Edit Completion Date for <?php echo $course->name; ?></h4>
						<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm', array(
							'id' => 'horizontalForm',
							'type' => 'vertical',
							)); ?>
							
							<div class="form-group datepicker">
								<?php echo $form->labelEx($courseProgressModel,'time_completed'); ?>
								<?php
								$this->widget(
									'bootstrap.widgets.TbDatePicker',
									array(
										'model' => $courseProgressModel,
										'attribute' => 'time_completed',
										)
									);
								?>
								<?php echo $form->error($courseProgressModel,'time_completed'); ?>
							</div>

	
							<div class="form-group buttons">
								<input type="hidden" name="UserCourseAccess[status]" value="Completed"/>
								<input type="hidden" name="UserCourseAccess[course_id]" value="<?php echo $course->id; ?>"/>
								<?php echo $form->hiddenField($courseProgressModel,'id'); ?>
								<?php echo CHtml::submitButton($courseProgressModel->isNewRecord ? 'Create' : 'Save', array('class'=>'btn btn-primary')); ?>
								<!-- 'class'=>'btn btn-primary' -->
							</div>

							<?php $this->endWidget(); ?>
					</div>
				</div>
			</div>
			<!-- End manual completion lightbox -->

		</td>

		
	</tr>

<?php } ?>
</table>









<?php } //end check if is existing model ?>






</div>