<?php

/**
 * This is the model class for table "user_course_access".
 *
 * The followings are the available columns in table 'user_course_access':
 * @property string $id
 * @property string $user_id
 * @property string $course_id
 * @property string $status
 *
 * The followings are the available model relations:
 * @property User $user
 * @property Course $course
 */
class UserCourseAccess extends CActiveRecord
{

	public $user_id; 
	public $course_id; 
	public $status; 
	public $id; 


	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserCourseAccess the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_course_access';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, course_id', 'required'),
			array('user_id, course_id, essay_grade', 'length', 'max'=>11),
			array('status, time_completed', 'length', 'max'=>60),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_id, course_id, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
			'course' => array(self::BELONGS_TO, 'Course', 'course_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'course_id' => 'Course',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('course_id',$this->course_id,true);
		$criteria->compare('status',$this->status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}


	protected function afterFind() {
		if($this->time_completed)
			$this->time_completed = date('m/d/Y', $this->time_completed);
		return parent::afterFind();		
	}


	public static function checkStatus($course_id, $user_id) {

		$cmd = Yii::app()->db->createCommand();
		$cmd->select('*');
		$cmd->where('course_id='.$course_id.' AND user_id='.$user_id);
		$cmd->from('user_course_access');
		$status = $cmd->queryRow(); 


		return $status;

	}


}