<?php

/**
 * This is the model class for table "response".
 *
 * The followings are the available columns in table 'response':
 * @property integer $id
 * @property string $user_id
 * @property string $question_id
 * @property string $course_id
 * @property string $response
 * @property integer $attempt
 * @property integer $correct
 *
 * The followings are the available model relations:
 * @property User $user
 * @property Course $course
 */
class Response extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Response the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}





	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'response';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, question_id, course_id, response', 'required'),
			array('attempt, correct', 'numerical', 'integerOnly'=>true),
			array('user_id, question_id, course_id', 'length', 'max'=>11),
			array('response', 'length', 'max'=>60),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_id, question_id, course_id, response, attempt', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
			'course' => array(self::BELONGS_TO, 'Course', 'course_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'question_id' => 'Question',
			'course_id' => 'Course',
			'response' => 'Response',
			'attempt' => 'Attempt',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('question_id',$this->question_id,true);
		$criteria->compare('course_id',$this->course_id,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('attempt',$this->attempt);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}