<?php

/**
 * This is the model class for table "course_has_category".
 *
 * The followings are the available columns in table 'course_has_category':
 * @property string $course_id
 * @property string $course_category_id
 * @property string $course_offering_id
 *
 * The followings are the available model relations:
 * @property Offerings $courseOffering
 * @property Course $course
 * @property CourseCategory $courseCategory
 */
class CourseHasCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CourseHasCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'course_has_category';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('course_id, course_category_id, course_offering_id', 'required'),
			array('course_id, course_category_id, course_offering_id', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_id, course_category_id, course_offering_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseOffering' => array(self::BELONGS_TO, 'Offerings', 'course_offering_id'),
			'course' => array(self::BELONGS_TO, 'Course', 'course_id'),
			'courseCategory' => array(self::BELONGS_TO, 'CourseCategory', 'course_category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_id' => 'Course',
			'course_category_id' => 'Course Category',
			'course_offering_id' => 'Course Offering',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_id',$this->course_id,true);
		$criteria->compare('course_category_id',$this->course_category_id,true);
		$criteria->compare('course_offering_id',$this->course_offering_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}