<?php

class QuestionController extends Controller
{	


	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	public function accessRules()
	{
		
	
		return array(
			array('allow',
				'actions'=>array('index','category','register','view','exam','review'),
				'users'=>array('@'),
			),

			array('allow',
				'actions'=>array('admin','update','create','delete','ajaxQuestion'),
				'users'=>array('@'),
			),

			// And so on.
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}


	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}


	public function loadModel($id)
	{
		$model=Question::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}


}