<?php

class CourseController extends Controller
{	


	public function filters()
	{
		return array(
			'accessControl',
			array('ext.booster.filters.BootstrapFilter - view,index,category,exam,review')
		);
	}	

	public function accessRules()
	{
		
	
		return array(
			array('allow',
				'actions'=>array('index','category','register','view','exam','review','certificate','generateDownloadCert'),
				'users'=>array('@'),
			),

			array('allow',
				'actions'=>array('admin','update','updateQuestion','create','delete','deletePowerpoint','deleteStudyguide','ajaxQuestion','report','exportreport'),
				'users'=>array('@'),
				'expression'=>'Yii::app()->user->access_level==1',
			),

			// And so on.
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}


	public function actionCategory($offering_id = NULL, $category_id = NULL, $course_id = NULL)
	{		

		$user = User::model()->findByPk(Yii::app()->user->id);
		

		$course_categories = NULL;
		$courses = NULL;

		$register_model=new RegisterForm;

		$this->layout='main';
		
		// Get course category models from offering id
		if($offering_id) {
			$course_categories=CourseCategory::model()->with(array(
					'offeringHasCategories'=>array(
					'select'=>false,
					'joinType'=>'INNER JOIN',
					'condition'=>'offering_id='.$offering_id,
					),
				))->findAll();
		}

		//Get courses with category id and offering id
		// if($offering_id && $category_id) {
		// 	$courses=Course::model()->with(array(
		// 			'courseHasCategories'=>array(
		// 			'select'=>false,
		// 			'joinType'=>'INNER JOIN',
		// 			'condition'=>'course_category_id='.$category_id,
		// 			),
		// 		))->findAll();
		// } 


		//Get all courses with offering id
		if($offering_id && !$category_id) {
			$courses=Course::model()->findAll();

		}


		$offerings = Offerings::model()->findAll();


		// Render category view
		$this->render('category',array(
								'register_model' => $register_model,
								'offering_id' => $offering_id,
								'category_id' => $category_id,
								'offerings' => $offerings,
								'course_categories' => $course_categories,
								'courses' => $courses,
								'user'=>$user));
	}




	public function actionView($id = NULL)
	{	

		$offerings = Offerings::model()->findAll();
		
		$course=Course::model()->with('courseHasCategories')->findByPk($id);

		$register_model=new RegisterForm;

			// Check if payment is activated on site

			if(Course::paymentActivated()) {

				// Collect registration input data
				if(isset($_POST['RegisterForm']))
				{
					$register_model->attributes=$_POST['RegisterForm'];
					if($register_model->validate()) {

						// Give course access to user
						$cmd = Yii::app()->db->createCommand();
						$cmd->insert('user_course_access',
								array('course_id'=>$id, 'user_id' => Yii::app()->user->id, 'status'=>'In Progress'));

						// Set flash confirmation
						Yii::app()->user->setFlash('success', "			
						<h2>Congratulations!</h2>
						<p>You have been enrolled in ".$course->name.".</p>
						");
					} 

					else {

						// Set flash confirmation
						Yii::app()->user->setFlash('error', "			
						<h2>Error</h2>
						<p>You Provided an incorrect promo code</p>
						");
					}
				}

			} else {

				// If payment is not activated

				if(isset($_GET['register_request']))
				{
					
						// Give course access to user
						$cmd = Yii::app()->db->createCommand();
						$cmd->insert('user_course_access',
								array('course_id'=>$id, 'user_id' => Yii::app()->user->id, 'status'=>'In Progress'));

						// Set flash confirmation
						Yii::app()->user->setFlash('success', "			
						<h2>Congratulations!</h2>
						<p>You have been enrolled in ".$course->name.".</p>
						");
					
				}
			
			}


				




		// Render view view
		$this->render('view',array(
								'register_model' => $register_model,
								'offerings' => $offerings,
								'course' => $course,
								));

	}


	public function actionIndex($id = NULL)
	{

		// Check if user has access
		if(!$this->checkCourseAccess($id)) {
			$this->redirect(array('dashboard/noaccess'));
		}

		$offerings = Offerings::model()->findAll();
		$course=Course::model()->with('courseHasCategories')->findByPk($id);


		// Get attempts
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('grade');
		$cmd->from('exam_results');
		$cmd->where('user_id='.Yii::app()->user->id);
		$cmd->andWhere('course_id='.$id);
		$attempts = $cmd->query(); 


		// Render view view
		$this->render('index',array(
								'offerings' => $offerings,
								'course' => $course,
								'attempts' => $attempts,
								));
	}





	public function actionExam($id = NULL)
	{

		// Check if user has access
		if(!$this->checkCourseAccess($id)) {
			$this->redirect(array('dashboard/noaccess'));
		}

		// Load new response model
		$response = new Response;

		// Load Course Model
		$course=Course::model()->with('courseHasCategories')->findByPk($id);

		// Get attempts
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('COUNT(*)');
		$cmd->from('exam_results');
		$cmd->where('user_id='.Yii::app()->user->id);
		$cmd->andWhere('course_id='.$id);
		$attempts = $cmd->queryScalar(); 
		$attempts++;	

			// If test submitted...
			if(isset($_POST['Response']))
			{

					// Save each response individuallly and check if correct
					foreach ($_POST['Response'] as $key=>$attr) {
						
						$response = new Response;
						$response->user_id=Yii::app()->user->id;
						$response->course_id=$id;
						$response->question_id=$key;
						$response->attempt=$attempts;
						$response->response=$attr;
						
						// Check if answer is correct
							
							//Get correct answer
							$cmd = Yii::app()->db->createCommand();
							$cmd->select = 'correct_answer_id';
							$cmd->from = 'question';
							$cmd->where = 'id='.$key;
							$correct_answer_id = $cmd->queryScalar();

							if($attr == $correct_answer_id) {
								$response->correct = 1;
							}


						$response->save();


					} //End save each response and check if correct


					// Get total grade for attempt
					$cmd = Yii::app()->db->createCommand();
					$cmd->select('COUNT(*)');
					$cmd->from('question');
					$cmd->where('course_id='.$id);
					$total_questions = $cmd->queryScalar(); 

					$cmd = Yii::app()->db->createCommand();
					$cmd->select('COUNT(*)');
					$cmd->from('response');
					$cmd->where('user_id='.Yii::app()->user->id);
					$cmd->andWhere('course_id='.$id);
					$cmd->andWhere('attempt='.$attempts);
					$cmd->andWhere('correct=1');
					$correct_responses = $cmd->queryScalar(); 

					$grade = number_format(($correct_responses/$total_questions)*100, 0);

				//Insert exam attempt
				$cmd->insert('exam_results',
					array('user_id'=>Yii::app()->user->id, 
						  'course_id' => $id,
						  'grade' => $grade,
						  ));
				

				// Set flash grades and change course status

				$passing_percentage = Course::getPassingPercentage($id);

				// Exam failed
				if($grade < $passing_percentage) {
					
					$result = "			
					<h2 class='red'>Exam Failed!</h2>
					<p>You scored a ".$grade."%. Please review your answers and try again.</p>";
					$result .= CHtml::link('Review Answers', array('course/review/'.$course->id.'/'.$attempts),array('class'=>'green_button'));
					$result .= CHtml::link('Dashboard', array('/course/'.$course->id),array('class'=>'orange_button'));			

				// Exam Passed
				} else {
					$result = "			
					<h2 class='green'>Exam Passed!</h2>
					<p>You scored a ".$grade."%.</p>";
					
					// Find filename for certificate
					$filename = Yii::app()->user->fname.' '.Yii::app()->user->lname;
					$filename .= '_'.$course->name;
					$filename = preg_replace('/[^a-zA-Z0-9_.-]/', '_', $filename);
					
					$result .= CHtml::link('Download Certificate', array('course_assets/certificates/'.$filename.'.pdf'), array('class'=>'green_button small', 'target'=>'_blank'));
					$result .= CHtml::link('Dashboard', array('/course/'.$course->id),array('class'=>'orange_button'));			



					// Update user_course_access to completed and add timestamp
					$cmd->update('user_course_access', 
							array('status'=>'Completed', 'time_completed'=>time()), 
							array('AND','user_id = :user_id','course_id = :course_id'),
							array(':user_id'=>Yii::app()->user->id, ':course_id'=>$id)
					);

					// Get current CEU's and then update
					$cmd = Yii::app()->db->createCommand();
					$cmd->select('CEU_count');
					$cmd->from('user');
					$cmd->where('id='.Yii::app()->user->id);
					$ceu_count = $cmd->queryScalar();

					$cmd = Yii::app()->db->createCommand();
					$cmd->select('ceu_credit');
					$cmd->from('course');
					$cmd->where('id='.$id);
					$ceu_credit = $cmd->queryScalar();


					$ceu_count = $ceu_count + $ceu_credit;
					
					$cmd->update('user', 
							array('CEU_count'=>$ceu_count), 
							'id = :user_id',
							array(':user_id'=>Yii::app()->user->id)
					);


						// Create Course Completion Certificate
						$this->actionCertificate($id);

					// Send Email to admins
					$variables[0] = $course;
					$variables[1] = $grade;
					$variables[2] = date("F j, Y, g:i a", time());
					$this->SendMail(Yii::app()->user->email, 'Training Course Completion Notification', 'course_completion', $variables);

					$notificationEmails = Yii::app()->params['notificationEmails'];
					if($notificationEmails) {
						foreach ($notificationEmails as $sendToEmail) {
							$this->SendMail($sendToEmail, 'Training Course Completion Notification', 'course_completion', $variables);
						}
					}
									
				}
				// End exam passed


				Yii::app()->user->setFlash('success', $result);

				$this->redirect(array('course/'.$id));
			
			} //End if test submitted


		$offerings = Offerings::model()->findAll();
		

		// Get questions with options
		$questions = Question::model()->with('options')->findAllByAttributes(array('course_id'=>$id),array('order'=>'course_order'));





		// Render exam view
		$this->render('exam',array(
								'offerings' => $offerings,
								'questions' => $questions,
								'response' => $response,
								'course' => $course,
								));
	
	}





	public function actionReview($id = NULL, $attempt = NULL)
	{

		$offerings = Offerings::model()->findAll();

		// Get questions with options
		$questions = Question::model()->with(array(
					'response'=> array(
						'condition'=>'attempt='.$attempt.' AND response.course_id='.$id,
						//'joinType'=>'LEFT INNER JOIN',
						)
					))->findAllByAttributes(array('course_id'=>$id));





		// $course_categories=CourseCategory::model()->with(array(
		// 			'offeringHasCategories'=>array(
		// 			'select'=>false,
		// 			'joinType'=>'INNER JOIN',
		// 			'condition'=>'offering_id='.$offering_id,
		// 			),
		// 		))->findAll();




		// Load Course Model
		$course=Course::model()->with('courseHasCategories')->findByPk($id);


		// Render review view
		$this->render('review',array(
								'offerings' => $offerings,
								'questions' => $questions,
								'course' => $course,
								'attempt'=>$attempt,
								));


	}




	
	public function actionCreate($id=NULL)
	{
		$this->layout='admin';

		$model=new Course;

		$questions = new Question;

		$categories=CourseCategory::model()->findAll();

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Course']))
		{
			$model->attributes=$_POST['Course'];
			
			$model->save();

			// Check if course categories / offering are set and save
			if(isset($_POST['course_category'])) {

					// Save each category individuallly
					foreach ($_POST['course_category'] as $key=>$attr) {
						
							if($attr != 'N') {

								//Find out what offering category has
								$offering_id = Course::getOfferingFromCategory($attr);

								$course_category = new CourseHasCategory;
								$course_category->course_id=$model->id;
								$course_category->course_category_id=$attr;
								$course_category->course_offering_id=$offering_id;
								$course_category->save();
							}


					} //End for each category
					
			} //End Check if course categories / offering are set and save

			$this->redirect(array('update','id'=>$model->id));

		}

		$this->render('create',array(
			'model'=>$model,
			'questions'=>$questions,
			'id'=>$id,
			'categories'=>$categories
		));
	}


	public function actionUpdate($id)
	{

		$this->layout='admin';

		$model=$this->loadModel($id);

		$questions = new Question;

		$options = new Option;

		$categories=CourseCategory::model()->findAll();


		if(isset($_POST['Course']))
		{
			$model->attributes=$_POST['Course'];
			

			// Upload pdf
			if(CUploadedFile::getInstance($model,'powerpoint')) {
				$model->powerpoint=CUploadedFile::getInstance($model,'powerpoint');
				$model->powerpoint->saveAs('course_assets/powerpoint/'.$model->powerpoint);
			}

			if(CUploadedFile::getInstance($model,'powerpoint_2')) {
				$model->powerpoint_2=CUploadedFile::getInstance($model,'powerpoint_2');
				$model->powerpoint_2->saveAs('course_assets/powerpoint/'.$model->powerpoint_2);
			}



			if(CUploadedFile::getInstance($model,'syllabus')) {
				$model->syllabus=CUploadedFile::getInstance($model,'syllabus');
				$model->syllabus->saveAs('course_assets/files/'.$model->syllabus);
			}






			// Upload pdf's
			if(CUploadedFile::getInstance($model,'study_guide')) {
				$model->study_guide=CUploadedFile::getInstance($model,'study_guide');
				$model->study_guide->saveAs('course_assets/study_guide/'.$model->study_guide);
			}

			if(CUploadedFile::getInstance($model,'study_guide_2')) {
				$model->study_guide_2=CUploadedFile::getInstance($model,'study_guide_2');
				$model->study_guide_2->saveAs('course_assets/study_guide/'.$model->study_guide_2);
			}

			if(CUploadedFile::getInstance($model,'case_study')) {
				$model->case_study=CUploadedFile::getInstance($model,'case_study');
				$model->case_study->saveAs('course_assets/files/'.$model->case_study);
			}


			
			$model->save();



			// Check if course categories / offering are set and save
			if(isset($_POST['course_category'])) {

					// Save each category individuallly
					foreach ($_POST['course_category'] as $key=>$attr) {
						
						// Check if unset and delete
						if($attr == 'N') {

							$cmd = Yii::app()->db->createCommand();
							$cmd->delete('course_has_category',
								'course_id=:course_id AND course_category_id=:course_category_id',
								array(':course_id'=>$id, ':course_category_id'=>$key)
							);
						
						// If not unset then add to course has category
						} else {

							// Check if already saved

							$cmd = Yii::app()->db->createCommand();
							$cmd->select('COUNT(*)');
							$cmd->from('course_has_category');
							$cmd->where('course_category_id='.$attr);
							$cmd->andWhere('course_id='.$id);
							$results = $cmd->queryScalar(); 

							if(!$results) {

								//Find out what offering category has
								$offering_id = Course::getOfferingFromCategory($attr);

								$course_category = new CourseHasCategory;
								$course_category->course_id=$model->id;
								$course_category->course_category_id=$attr;
								$course_category->course_offering_id=$offering_id;
								$course_category->save();
							}

						}

					} //End for each category

			} //End Check if course categories / offering are set and save


		} //End save model



		// Get list of users for compliancy checks
		$users = User::model()->findAll(array('condition'=>'active=1'));



		$this->render('update',array(
			'model'=>$model,
			'questions'=>$questions,
			'id'=>$id,
			'options'=>$options,
			'categories'=>$categories,
			'users'=>$users
		));
	}


	public function actionAjaxQuestion()
	{
		$model=new Question;
		

    	if(isset($_POST['Question']))
    	{

    		$model->attributes=$_POST['Question'];
    		if($model->validate()) {
           		$model->save();
    		}

    		$correct_answer = $_POST['correct_answer'];

    		// Loop through all submitted options
    		$i=1;
    		foreach ($_POST['Option'] as $value) {
    			$options = new Option;
    			$options->content = $value;
    			$options->question_id=$model->id;
    			if($correct_answer == $i){
    				$options->correct=1;
    			}
    			if($options->content) {
    				$options->save();

    				// If correct answer, update correct_answer_id in questions table
    				if($correct_answer == $i){
	    				$cmd = Yii::app()->db->createCommand();
	    				$cmd->update('question', array(
	    					'correct_answer_id'=>$options->id,
	    					), 'id=:id', array(':id'=>$model->id));
    				}
    			}
    			$i++;
    		}


    		
   		}

	}

	public function actionUpdateQuestion($id)
	{
		
		if(isset($_POST['Question']))
    	{
    		$model=Question::model()->findByPk($id);

    		$model->attributes=$_POST['Question'];
    		if($model->validate()) {
           		$model->save();
    		}

    		// Delete all existing question options
    		$cmd = Yii::app()->db->createCommand();
    		$cmd->delete('option', 'question_id=:id', array(':id'=>$id));


    		$correct_answer = NULL;

    		if(isset($_POST['correct_answer'])) {
    			$correct_answer = $_POST['correct_answer'];
    		}

    		// Loop through all submitted options
    		$i=1;
    		foreach ($_POST['Option'] as $value) {
    			$options = new Option;
    			$options->content = $value;
    			$options->question_id=$model->id;
    			if($correct_answer == $i){
    				$options->correct=1;
    			}

    			// Check if option has content, if so save
    			if($options->content) {
    				$options->save();

    				// If correct answer, update correct_answer_id in questions table
    				if($correct_answer == $i){
	    				$cmd = Yii::app()->db->createCommand();
	    				$cmd->update('question', array(
	    					'correct_answer_id'=>$options->id,
	    					), 'id=:id', array(':id'=>$model->id));
    				}
    			}

    			$i++;
    		}

    	} else {

			$questions = Question::model()->with('options')->findByPk($id);
			$course_id = $questions->course_id;
			
			$this->layout='blank';

			$this->render('updateQuestion',array(
				'questions'=>$questions,
				'id'=>$course_id
			));
		}
	}



	public function actionGenerateDownloadCert($id)
	{
		$this->layout='blank';

		$model = Course::model()->findByPk($id);

		$url = $model->generateCertificate();

		// echo $url;
		header('Content-type: application/pdf');
		header('Content-Disposition: inline; filename="'.Yii::app()->request->baseUrl.'/'.$url.'"');
		@readfile($url);
	}




	public function actionCertificate($id)
	{
		$this->layout='blank';

		$model = Course::model()->findByPk($id);

		$model->generateCertificate();


	}


	public function actionAdmin()
	{
		$this->layout='admin';

		$model=new Course('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Course']))
			$model->attributes=$_GET['Course'];
		
		$this->render('admin',array(
			'model'=>$model,
		));

	}


	public function actionReport($id=NULL)
	{
		// Individual Export View
		if($id) {

			$model = Course::model()->with('userCourseAccesses')->findByPk($id);

			// filename for download
			$filename = str_replace(' ', '_', $model->name);
			$filename = $filename . ".csv";

			header("Content-Disposition: attachment; filename=\"$filename\"");
			header("Content-Type: text/csv; charset=UTF-16LE");

			$out = fopen("php://output", 'w');


			$csvRow = array(
					'Name' => '',
					'Email' => '',
					'Status' => '',
					'Time Completed' => '',
				);
			
			$flag = false;
			foreach($model->userCourseAccesses as $row) {
				// echo $row;
				if(!$flag) {
     				// display field/column names as first row
					fputcsv($out, array_keys($csvRow), ',', '"');
					$flag = true;
				}
				// array_walk($row, 'cleanData');
				// echo implode("\t", $row) . "\r\n";

				

				$student = User::getUserById($row->user_id);	

				$csvRow['Name'] = $student['fname'].' '.$student['lname'];
				$csvRow['Email'] = $student['email'];
				$csvRow['Status'] = $row->status;
				$csvRow['Time Completed'] = $row->time_completed;

				fputcsv($out, $csvRow, ',', '"');
			}
			fclose($out);
			exit;
		}




		// Export entire database
		if(isset($_GET['export'])) {
			$model = UserCourseAccess::model()->findAll(array('order'=>'course_id'));

			// filename for download
			$filename = "all_courses.csv";

			// header("Content-Disposition: attachment; filename=\"$filename\"");
			// header("Content-Type: text/csv; charset=UTF-16LE");

			$out = fopen("php://output", 'w');


			$csvRow = array(
					'Course' => '',
					'Name' => '',
					'Email' => '',
					'Status' => '',
					'Time Completed' => '',
				);
			
			$flag = false;

			foreach($model as $row) {
				// echo $row;
				if(!$flag) {
     				// display field/column names as first row
					fputcsv($out, array_keys($csvRow), ',', '"');
					$flag = true;
				}
				// array_walk($row, 'cleanData');
				// echo implode("\t", $row) . "\r\n";
				


				$student = User::getUserById($row->user_id);	

				$csvRow['Course'] = Course::getCourseNameByID($row->course_id);
				$csvRow['Name'] = $student['fname'].' '.$student['lname'];
				$csvRow['Email'] = $student['email'];
				$csvRow['Status'] = $row->status;
				$csvRow['Time Completed'] = $row->time_completed;

				fputcsv($out, $csvRow, ',', '"');
			}
			fclose($out);
			exit;

		}



		// General View
		$model = Course::model()->with('userCourseAccesses')->findAll();
		$this->render('report',array(
			'model'=>$model,
			));


	}


	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}


	public function actionDeletePowerpoint($id)
	{
		$model = Course::model()->findByPk($id);

		$version = NULL;

		if(isset($_GET['version']))
			$version = $_GET['version'];
		
		if($version == 2) {
			unlink('course_assets/powerpoint/'.$model->powerpoint_2);
			$model->powerpoint_2 = NULL;

		} else if ($version == 3) {
			unlink('course_assets/files/'.$model->syllabus);
			$model->syllabus = NULL;
		
		} else {
			unlink('course_assets/powerpoint/'.$model->powerpoint);
			$model->powerpoint = NULL;
		}

		$model->save();
		$this->redirect(array('update','id'=>$model->id));
	}

	public function actionDeleteStudyguide($id)
	{
		$model = Course::model()->findByPk($id);
		
		$version = NULL;

		if(isset($_GET['version']))
			$version = $_GET['version'];
		
		if($version == 2) {
			unlink('course_assets/study_guide/'.$model->study_guide_2);
			$model->study_guide_2 = NULL;

		} else if ($version == 3) {
			unlink('course_assets/files/'.$model->case_study);
			$model->case_study = NULL;
		
		} else {
			unlink('course_assets/study_guide/'.$model->study_guide);
			$model->study_guide = NULL;
		}
		
		
		$model->save();
		$this->redirect(array('update','id'=>$model->id));
	}


	
	


	public function actionExportReport($id)
	{
		
		header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="User-Export-'.date('m-d-Y').'.csv"');


		$list[] = 'User | Status | Compliance | Expiration Date';
		
        $course = Course::model()->findByPk($id);
        $users = User::model()->findAll();

        foreach ($users as $user) { 

			$results = UserCourseAccess::checkStatus($course->id, $user->id);
			$compliance = User::checkCompliance($user->id, $course->id);

			// Get Status
			if($results['status'] == '') {
				$status = 'Not Taken';
			} else {
				$status = $results['status'];
			} 


			// Get Compliance
			if(isset($compliance) && $compliance['compliant'] != 1) {
				$compliancy = 'Not Compliant';
			}

			if($results['status'] == 'Completed' && $compliance['compliant'] != 0) {
				$compliancy = 'Compliant';
			}


			// Expiration Date
			$expiration = NULL;
			if(isset($compliance) && isset($compliance['expiration_date'])) {
				$expiration = $compliance['expiration_date'];
			} else if(isset($compliance) && isset($compliance['required_by_date'])) {
				$expiration = $compliance['required_by_date'];
			}
        	
			if($user->active)
        		$list[] = $user->fname.' '.$user->lname.'|'.$status.'|'.$compliancy.'|'.$expiration;

        } //endforeach coursemodel



        $output = fopen('php://output', 'w');

        // Create CSV
        foreach ($list as $line) {
        	fputcsv($output, explode('|',$line));
        }


	}










	public function loadModel($id)
	{
		$model=Course::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	public function isChecked($course_id = NULL, $course_category_id)
	{
		if($course_id) {
			$cmd = Yii::app()->db->createCommand();
			$cmd->select('COUNT(*)');
			$cmd->from('course_has_category');
			$cmd->where('course_category_id='.$course_category_id);
			$cmd->andWhere('course_id='.$course_id);
			$results = $cmd->queryScalar();

			if($results)
				return true;
		}
	}






}