<?php

$offering_id = NULL;
foreach ($course->courseHasCategories as $value) {
	$offering_id = $value->course_offering_id;
}

echo $this->renderPartial('/layouts/_topmenu',array('offerings' => $offerings, 'offering_id' => $offering_id)); 

?>


<?php if(Yii::app()->user->hasFlash('success')): ?>   

		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery.fancybox.open('#confirmation_lightbox');
			});
		</script>

		<div style="display:none">
			<div id="confirmation_lightbox">

				<?php echo Yii::app()->user->getFlash('success'); ?>
				
				<div class="clear"></div>
			</div>
		</div>

<?php endif;  ?>



<div class="wrapper single_course evaluation enrolled">


	<div id="sidebar">

		
		<div class="course_status <?php if($this->getCourseStatus($course->id) == 'Completed') echo "passed"; ?>">Course <?php echo $this->getCourseStatus($course->id);?></div>

		<ul id="course_info">
			<li>
				<h4>Instruction Methods</h4>
				<?php echo $course->instruction_methods;?>
			</li>

			<li class="evaluation_method">
				<h4>METHOD OF EVALUATION</h4>
				<?php echo $course->evaluation_method;?>
			</li>
		</ul>

	</div>


	<div id="page_content">

		<h1><?php echo $course->name;?></h1>

		<h2>Course Evaluation</h2>

		
		<div class="sep"></div>

		<?php $form=$this->beginWidget('CActiveForm', array(
			'id'=>'evaluation-form',
			'enableAjaxValidation'=>false,
			)); ?>

			<p class="note">Fields with <span class="required">*</span> are required.</p>

			<?php echo $form->errorSummary($model); ?>

			<div class="row">
				<?php echo $form->labelEx($model,'student_name'); ?>
				<?php echo $form->textField($model,'student_name',array('size'=>60,'maxlength'=>60)); ?>
				<?php echo $form->error($model,'student_name'); ?>
			</div>

			<div class="row">
				<?php echo $form->labelEx($model,'question_1'); ?>
				<?php echo $form->textArea($model,'question_1',array('rows'=>6, 'cols'=>50)); ?>
				<?php echo $form->error($model,'question_1'); ?>
			</div>

			<div class="row">
				<?php echo $form->labelEx($model,'question_2'); ?>
				<?php echo $form->textArea($model,'question_2',array('rows'=>6, 'cols'=>50)); ?>
				<?php echo $form->error($model,'question_2'); ?>
			</div>

			<div class="row">
				<?php echo $form->labelEx($model,'question_3'); ?>
				<?php echo $form->textArea($model,'question_3',array('rows'=>6, 'cols'=>50)); ?>
				<?php echo $form->error($model,'question_3'); ?>
			</div>

			<div class="row">
				<?php echo $form->labelEx($model,'question_4'); ?>
				<?php echo $form->textArea($model,'question_4',array('rows'=>6, 'cols'=>50)); ?>
				<?php echo $form->error($model,'question_4'); ?>
			</div>

			<div class="row">
				<?php echo $form->labelEx($model,'question_5'); ?>
				<?php echo $form->textArea($model,'question_5',array('rows'=>6, 'cols'=>50)); ?>
				<?php echo $form->error($model,'question_5'); ?>
			</div>

			<div class="row">
				<?php echo $form->labelEx($model,'rating'); ?>
				<?php echo $form->error($model,'rating'); ?>
				<?php
                echo $form->radioButtonList($model, 'rating',
                    array(  1 => 'Poor',
                            2 => 'Fair',
                            3 => 'Average',
                            4 => 'Very Good',
                            5 => 'Excellent' 
                           ) 
                    );
            	?>
            </div>

			<div class="row buttons">
				<?php echo CHtml::submitButton('Submit and Access Certificate'); ?>
			</div>

			<?php $this->endWidget(); ?>


	</div> <!-- end page content -->



	<div class="clear"></div>


</div> <!-- wrapper -->
