<?php
/* @var $this AccountController */
/* @var $model Course */

Yii::app()->clientScript->registerCoreScript('jquery');
$baseUrl = Yii::app()->baseUrl;
$cs = Yii::app()->getClientScript();
$cs->registerScriptFile($baseUrl.'/js/fancybox/jquery.fancybox.pack.js');
$cs->registerCssFile($baseUrl.'/js/fancybox/jquery.fancybox.css');
$cs->registerScript('fancybox', '
jQuery(document).ready(function() {
	jQuery("a#inline").fancybox({
				"hideOnContentClick": false,
				"overlayColor"		: "#000",
				"overlayOpacity"	: "0.45"
			});
});'
);


echo $this->renderPartial('/layouts/_topmenu',array('offerings' => $offerings, 'offering_id' => $offering_id)); 

?>


<div class="wrapper dashboard">

	<?php /*
	<div id="sidebar">

		<ul class="module">
			<li>
				<h4>Your CEU's</h4>
				<p>You currently have <?php echo $ceu_count; ?> course education units</p>
			</li>

			<!-- <li>
				<h4>Recommended Courses</h4>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
			</li> -->
			
		</ul><!-- module -->

		
		<!-- <ul class="module registration">
			<li>
				<h4>Become a Certified addiction professional</h4>
				<p>Purchase access to all of the Certified Addiction Professional classes and save. Full access is $3500</p>
				<a class="blue_button" id="inline" href="#cap_registration_lightbox">Full CAP Access</a>
			</li>
		</ul>


		<ul class="module registration">
			<li>
				<h4>Further your education</h4>
				<p>Purchase access to all of the Professional Development courses for a year. The cost for yearly access it $299.</p>
				<a class="blue_button" id="inline" href="#ceu_registration_lightbox">Yearly Access</a>
			</li>
		</ul> -->

		

	</div><!-- sidebar -->
	*/?>

	<div id="page_content" class="fullwidth">


		<h1>Welcome <?php echo Yii::app()->user->fname; ?></h1>
		<p>Welcome to our online learning application. Please click on the blue button below to access and register for our courses. You can also view the courses for which you have enrolled and your completed courses below.</p>
		<?php echo CHtml::link('Browse Courses', array('/course/category/1'),array('class'=>'blue_button')); ?>
		<div class="sep"></div>



		<div id="enrolled_courses" class="course_list">
			<h2>Enrolled Courses</h2>
			<?php if($courses) { ?>

			<?php  foreach ($courses as $attr) { ?>
				<?php if($attr->status == 'In Progress') : ?>
					<div class="entry">
						<?php echo CHtml::link($attr->course->name, array('course/'.$attr->course->id),array('class'=>'#')); ?>
						<div class="course_status"><?php echo $attr->status; ?></div>
						<div class="clear"></div>
					</div>
				<?php endif; ?>
			<?php } ?>

			<?php } else { ?>

			<p><em>Your are not enrolled in any courses. Select either Professional Development or Certification Courses from the menu above to enroll now.</em></p>

			<?php } //end if courses ?>
		</div>

		<div class="sep"></div>

		
		<div id="completed_courses" class="course_list">
			<h2>Completed Courses</h2>
				
			<?php $completions = 'false'; ?>

				<?php 
					foreach ($courses as $attr) { 
						$compliance = User::checkCompliance(Yii::app()->user->id, $attr->course->id);
				?>

					<?php if($attr->status == 'Completed' && $compliance['compliant']==1) : ?>
						<?php $completions = 'true'; ?>
						<div class="entry">
							<?php echo CHtml::link($attr->course->name, array('course/'.$attr->course->id),array('class'=>'#')); ?>
							
							<?php //echo $compliance['expiration_date_warning']; ?>

							<?php if(isset($compliance['expiration_date'])) { ?>
							<div class="course_status <?php if(isset($compliance['expiration_date_warning'])) echo 'warning'; ?>">
								<span>Expires <?php echo $compliance['expiration_date']; ?></span>
							</div>
							<?php } ?>

							<div class="course_status">
								<?php echo $attr->status; ?> <?php echo $attr->time_completed; ?>
							</div>
							
							<div class="clear"></div>
						</div>
					<?php endif; ?>
				<?php } ?>


			<?php if($completions != 'true') { ?>
				<p><em>Your have not completed in any courses yet.</em></p>
			<?php } ?>
		</div>

		<div class="sep"></div>

		<div id="required_courses" class="course_list">
			<h2>Required Courses</h2>
			<?php  
				foreach ($allCourses as $course) {
					
					$results = UserCourseAccess::checkStatus($course->id, Yii::app()->user->id);
					$compliance = User::checkCompliance(Yii::app()->user->id, $course->id);

					if(($results['status'] == 'Completed' || $results['status'] != 'In Progress') && $compliance['compliant'] == 1) {} else if ($course->isRequired()) {
			?>
				
						<div class="entry">
							<?php echo CHtml::link($course->name, array('course/view/'.$course->id),array('class'=>'#')); ?>
							<?php if($results['status'] == 'In Progress') { ?>
							<div class="course_status">In Progress - Not Yet Compliant</div>
							<?php } else if($compliance['reason'] == 1) { ?>
							<div class="course_status">Expired - Not Compliant</div>
							<?php } else { ?>
							<div class="course_status">Not Compliant</div>
							<?php } ?>

							<div class="clear"></div>
						</div>
			<?php 
					} //end if course completed or in progress
				} 
			?>

		</div>

</div>

<div class="clear"></div>

<!-- REGISTRATION LIGHTBOX -->

	<div style="display:none">
		<div id="ceu_registration_lightbox" class="registration_lightbox">
			<h2>Purchase Yearly Access</h2>
			<p><strong>Professional Development Courses</strong></p>
			<p><strong>Cost:</strong> $299</p>
			<img src="<?php echo Yii::app()->request->baseUrl; ?>/images/creditcards.png">
			<div class="form">
			<?php $form=$this->beginWidget('CActiveForm', array(
				'id'=>'login-form',
				'enableClientValidation'=>true,
				'clientOptions'=>array(
					'validateOnSubmit'=>true,
					),
					)); ?>

					<?php //echo(Yii::app()->user->returnUrl);?>

					<div class="row">
						<?php echo $form->textField($register_model,'cc_num',array('placeholder'=>'Credit Card Number', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'cc_num'); ?>
					</div>

					<div class="row">
						<?php echo $form->textField($register_model,'cc_name',array('placeholder'=>'Name on Card', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'cc_name'); ?>
					</div>

					<div class="row">
						<?php echo $form->textField($register_model,'promo_code',array('placeholder'=>'Promo Code', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'promo_code'); ?>
					</div>


					<div class="row buttons">
						<?php echo CHtml::submitButton('REGISTER NOW', array('class'=>'submit')); ?>
						<div class="clear"></div>
					</div>

			<?php $this->endWidget(); ?>
			</div><!-- form -->
		</div><!-- registration_lightbox -->
	</div> <!-- display:none -->



	<!-- REGISTRATION LIGHTBOX -->

	<div style="display:none">
		<div id="cap_registration_lightbox" class="registration_lightbox">
			<h2>Purchase Full Access</h2>
			<p><strong>Certified Addiction Professional</strong></p>
			<p><strong>Cost:</strong> $3500</p>
			<img src="<?php echo Yii::app()->request->baseUrl; ?>/images/creditcards.png">
			<div class="form">
			<?php $form=$this->beginWidget('CActiveForm', array(
				'id'=>'login-form',
				'enableClientValidation'=>true,
				'clientOptions'=>array(
					'validateOnSubmit'=>true,
					),
					)); ?>

					<?php //echo(Yii::app()->user->returnUrl);?>

					<div class="row">
						<?php echo $form->textField($register_model,'cc_num',array('placeholder'=>'Credit Card Number', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'cc_num'); ?>
					</div>

					<div class="row">
						<?php echo $form->textField($register_model,'cc_name',array('placeholder'=>'Name on Card', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'cc_name'); ?>
					</div>

					<div class="row">
						<?php echo $form->textField($register_model,'promo_code',array('placeholder'=>'Promo Code', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'promo_code'); ?>
					</div>


					<div class="row buttons">
						<?php echo CHtml::submitButton('REGISTER NOW', array('class'=>'submit')); ?>
						<div class="clear"></div>
					</div>

			<?php $this->endWidget(); ?>
			</div><!-- form -->
		</div><!-- registration_lightbox -->
	</div> <!-- display:none -->


</div>