<?php
/* @var $this AccountController */
/* @var $model Course */


//Add scripts
$baseUrl = Yii::app()->baseUrl; 
$cs = Yii::app()->getClientScript();
Yii::app()->clientScript->registerCoreScript('jquery');  
$cs->registerScriptFile($baseUrl.'/js/fancybox/jquery.fancybox.pack.js');
$cs->registerCssFile($baseUrl.'/js/fancybox/jquery.fancybox.css');
$cs->registerScript('fancybox', '
jQuery(document).ready(function() {
	jQuery("a#inline").fancybox({
				"hideOnContentClick": false,
				"overlayColor"		: "#000",
				"overlayOpacity"	: "0.45"
			});
});'
);

$offering_id = NULL;
foreach ($course->courseHasCategories as $value) {
	$offering_id = $value->course_offering_id;
}

echo $this->renderPartial('/layouts/_topmenu',array('offerings' => $offerings, 'offering_id' => $offering_id)); 

?>


<div class="wrapper single_course">


	<div id="sidebar">

		<ul id="course_info">
			<li>
				<h4>Registration Cost</h4>
				<?php echo $course->cost;?>
			</li>

			<li>
				<h4>Instruction Methods</h4>
				<?php echo $course->instruction_methods;?>
			</li>

			<li class="evaluation_method">
				<h4>METHOD OF EVALUATION</h4>
				<?php if ($course->essay_question) { ?> Essay Question <?php }?>
				<?php if (!$course->essay_question) { ?> Multiple Choice <?php }?>
			</li>
		</ul>
	
	
		

	</div>


	<div id="page_content">

		<?php if(Yii::app()->user->hasFlash('error')): ?> 

			<div class="errorMessage">
				<h3>Error</h3>
				<p>You provided an incorrect promo code.</p>
			</div>

		<?php endif;  ?>

		<h1><?php echo $course->name;?></h1>

		<?php echo $course->description;?>
		
		<br><br>
	
		<?php if(!$this->checkCourseAccess($course->id)) { ?>
			
			<!-- Check if payment is activated, and display lighbox OR display immediate registration -->
			<?php if(Course::paymentActivated()) { ?>
				<a class="orange_button" id="inline" href="#registration_lightbox">REGISTER FOR THIS COURSE</a>
			<?php } else { ?>
				<?php echo CHtml::link('REGISTER FOR THIS COURSE', array('course/view/'.$course->id.'/?register_request=true'),array('class'=>'orange_button')); ?>
			<?php } ?>
		
		<?php } else { ?>
		
			<?php echo CHtml::link('Access Course', array('course/'.$course->id.'/'),array('class'=>'green_button')); ?>
		
		<?php } ?>


	</div>

	<div class="clear"></div>


	<?php if(Yii::app()->user->hasFlash('success')): ?>   

		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery.fancybox.open('#confirmation_lightbox');
			});
		</script>

		<div style="display:none">
			<div id="confirmation_lightbox">

				<?php echo Yii::app()->user->getFlash('success'); ?>

				<?php echo CHtml::link('Access Course Now', array('course/'.$course->id.'/'),array('class'=>'green_button'));?>
				<?php echo CHtml::link('Dashboard', array('/dashboard'),array('class'=>'orange_button'));?>
				<div class="clear"></div>
			</div>
		</div>

	<?php endif;  ?>



	<!-- REGISTRATION LIGHTBOX -->

	<div style="display:none">
		<div id="registration_lightbox" class="registration_lightbox">
			<h2>Purchase This Course</h2>
			<p><strong>Course:</strong> <?php echo $course->name;?></p>
			<p><strong>Cost:</strong> <?php echo $course->cost;?></p>
			<img src="<?php echo Yii::app()->request->baseUrl; ?>/images/creditcards.png">
			<div class="form">
			<?php $form=$this->beginWidget('CActiveForm', array(
				'id'=>'login-form',
				'enableClientValidation'=>true,
				'clientOptions'=>array(
					'validateOnSubmit'=>true
					),
				'htmlOptions' => array('enctype' => 'multipart/form-data'),
				)); ?>

					<?php //echo(Yii::app()->user->returnUrl);?>

					<!-- <div class="row">
						<?php echo $form->textField($register_model,'cc_num',array('placeholder'=>'Credit Card Number', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'cc_num'); ?>
					</div>

					<div class="row">
						<?php echo $form->textField($register_model,'cc_name',array('placeholder'=>'Name on Card', 'class'=>'text')); ?>
						<?php echo $form->error($register_model,'cc_name'); ?>
					</div>
					-->

					<div class="row">
						<?php echo $form->textField($register_model,'promo_code',array('placeholder'=>'Promo Code', 'class'=>'text')); ?>
						<?php //echo $form->error($register_model,'promo_code'); ?>
					</div> 

					<div class="row">
						<p class="description">Payment is currently disabled, but you may access this course if you have a promo code.</p>
					</div>

					

					


					<div class="row buttons">
						<?php echo $form->hiddenField($register_model, 'course_id' ,array('value'=>$course->id)); ?>
						<?php echo CHtml::submitButton('REGISTER NOW', array('class'=>'submit')); ?>
						<div class="clear"></div>
					</div>

			<?php $this->endWidget(); ?>
			</div><!-- form -->
		</div><!-- registration_lightbox -->
	</div> <!-- display:none -->

</div>
