<?php
/* @var $this AccountController */
/* @var $model Course */


//Add scripts
$baseUrl = Yii::app()->baseUrl; 
$cs = Yii::app()->getClientScript();
Yii::app()->clientScript->registerCoreScript('jquery');  
$cs->registerScriptFile($baseUrl.'/js/fancybox/jquery.fancybox.pack.js');
$cs->registerCssFile($baseUrl.'/js/fancybox/jquery.fancybox.css');
$cs->registerScript('fancybox', '
jQuery(document).ready(function() {
	jQuery("a#inline").fancybox({
				"hideOnContentClick": false,
				"overlayColor"		: "#000",
				"overlayOpacity"	: "0.45"
			});

	jQuery("a#iframe").fancybox({
				"type": "iframe",
				"hideOnContentClick": false,
				"overlayColor"		: "#000",
				"overlayOpacity"	: "0.45",
			});
});'
);

$offering_id = NULL;
foreach ($course->courseHasCategories as $value) {
	$offering_id = $value->course_offering_id;
}

echo $this->renderPartial('/layouts/_topmenu',array('offerings' => $offerings, 'offering_id' => $offering_id)); 

?>


<?php if(Yii::app()->user->hasFlash('success')): ?>   

		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery.fancybox.open('#confirmation_lightbox');
			});
		</script>

		<div style="display:none">
			<div id="confirmation_lightbox">

				<?php echo Yii::app()->user->getFlash('success'); ?>
				
				<div class="clear"></div>
			</div>
		</div>

<?php endif;  ?>



<div class="wrapper single_course enrolled">


	<div id="sidebar">

		
		<!-- <div class="course_status <?php if($this->getCourseStatus($course->id) == 'Completed') echo "passed"; ?>">
			Course <?php echo $this->getCourseStatus($course->id);?>
		</div> -->

		<ul id="course_info">
			<li>
				<h4>Instruction Methods</h4>
				<?php echo $course->instruction_methods;?>
			</li>

			<li class="evaluation_method">
				<h4>METHOD OF EVALUATION</h4>
				<?php if ($course->essay_question) { ?> Essay Question <?php }?>
				<?php if (!$course->essay_question) { ?> Multiple Choice <?php }?>
			</li>
		</ul>

	</div>


	<div id="page_content">

		<h1><?php echo $course->name;?></h1>

		<p><?php echo $course->description;?></p>

		
		<div class="sep"></div>


		<?php if($course->syllabus) : ?>
		<h2>Syllabus</h2>
		<p><?php echo CHtml::link('Download Syllabus', 
			array('course_assets/files/'.$course->syllabus),
				array('class'=>'blue_button inline','target'=>'_blank')); 
			?>
		</p>
		<div class="sep"></div>

		<?php endif; ?>



		<?php if($course->study_guide) : ?>
		<h2>Study Guide</h2>
		<p><?php echo CHtml::link('Download Study guide', 
			array('course_assets/study_guide/'.$course->study_guide),
				array('class'=>'blue_button inline','target'=>'_blank')); 
			?>
		</p>
			<?php if($course->study_guide_2) : ?>
				<p><?php echo CHtml::link('Download the Second Study guide', 
					array('course_assets/study_guide/'.$course->study_guide_2),
					array('class'=>'blue_button inline','target'=>'_blank')); 
					?>
				</p>
			<?php endif; ?>

		<div class="sep"></div>

		<?php endif; ?>

		

		
		
		<?php if($course->powerpoint) : ?>
		<h2>Powerpoint</h2>
		<p>
			<a href="#powerpoint_viewer" class="blue_button inline" id="inline">View the Powerpoint</a>

			&nbsp;&nbsp;or&nbsp;&nbsp;
			<?php echo CHtml::link('Download the Powerpoint', 
				array('course_assets/powerpoint/'.$course->powerpoint),
				array('class'=>'green_button inline','target'=>'_blank')); 
			?>
		</p>

			<?php if($course->powerpoint_2) : ?>
				
				<p>
				<a href="#powerpoint_viewer2" class="blue_button inline" id="inline">View the Second Powerpoint</a>

					&nbsp;&nbsp;or&nbsp;&nbsp;
					<?php echo CHtml::link('Download the Second Powerpoint', 
						array('course_assets/powerpoint/'.$course->powerpoint_2),
						array('class'=>'green_button inline','target'=>'_blank')); 
						?>
					</p>

			<?php endif; ?>

		<div class="sep"></div>
		<?php endif; ?>


		<?php if($course->case_study) : ?>
		<h2>Case Study</h2>
		<p><?php echo CHtml::link('Download Case Study', 
			array('course_assets/files/'.$course->case_study),
				array('class'=>'blue_button inline','target'=>'_blank')); 
			?>
		</p>
		<div class="sep"></div>

		<?php endif; ?>

		
		<?php if($course->video) : ?>
			<h2>Course Video</h2>
			<?php echo $course->video; ?>
			<div class="sep"></div>
		<?php endif; ?>
	
		

		<div class="left">
			
			<h2>Take the Exam</h2>

			<?php if($course->essay_question) : ?>
				

				<p><a href="#pre_test_essay" class="green_button inline" id="inline">Show Essay Question</a></p>

			<?php endif ?>

				
			<p> 
				<?php if($course->essay_question && !$course->getEssayStatus()): ?>
					<div class="gray_button inline">Take the Exam</div>				
					<p><em><small>Please complete the essay before proceeding to the exam</small></em></p>	
				<?php else: ?>
					<a href="#pre_test" class="disabled green_button inline" id="inline">Take the Exam</a>
				<?php endif; ?>
			</p>
			<!-- <p><em>You have unlimited attempts to pass.</em></p> -->
			
			
			
		</div>


		<div class="right">

			<?php if($course->essay_question) : ?>
			<h2>Essay Grade</h2>
			<ul>
				<?php if ($course->getEssayStatus()): ?>
					<li style="color:#7EC639">Essay Passed</li>
				<?php else: ?>
					<li>Not Yet Graded</li>
				<?php endif ?>
				
			</ul>
			<?php endif ?>

			<div class="spacer30"></div>
			
			
			<h2>Exam Attempts</h2>
			<?php if(count($attempts)) { ?>
			<ul>
				<?php $i=1; foreach ($attempts as $attr) {?>

					<li>Attempt <?php echo $i;?> 
					
					<?php echo CHtml::link('Review', array('course/review/'.$course->id.'/'.$i),array()); ?>
						
					<?php $passing_percentage = Course::getPassingPercentage($course->id); ?>

						<span <?php if($attr['grade'] > $passing_percentage) echo "class='passed'"; ?>>
							<?php echo $attr['grade'];?>%
						</span>
					</li>

				<?php $i++; } ?>
			</ul>

			<?php } else { ?>
				<p><em>You currently have no attempts.</em></p>
			<?php } ?>

			
		</div>
		
		<div class="clear"></div>

		<?php  
			$compliance = User::checkCompliance(Yii::app()->user->id, $course->id);
		?>
	
		<?php if($this->getCourseStatus($course->id) == 'Completed' && $compliance['compliant'] == 1) : ?>
				
				<div class="course_evaluation">
				<div class="sep"></div>
				<div class="left">
					<h2>Fill out the course evaluation</h2>
					<p><em>Please complete this before accessing your certificate.</em></p>
					<a href="<?php echo Yii::app()->getBaseUrl('true'); ?>/evaluation/<?php echo $course->id; ?>" class="green_button inline">Course Evaluation</a>
				</div>
				</div>
				
				<div class="clear"></div>

				<div class="sep"></div>
				<h2>Certificate of Completion</h2>

				<?php 
					// Find filename for certificate
					$filename = Yii::app()->user->fname.' '.Yii::app()->user->lname;
					$filename .= '_'.$course->name;
					$filename = preg_replace('/[^a-zA-Z0-9_.-]/', '_', $filename);
				?>
				
				<a target="_blank" href="<?php echo Yii::app()->getBaseUrl('true'); ?>/course/generatedownloadcert/<?php echo $course->id;?>" class="green_button inline">Download Your Certificate Of Completion</a>
		 
		<?php endif; ?>

	</div> <!-- end page content -->



	<div class="clear"></div>


	


	<div style="display:none">
		<div id="powerpoint_viewer">
			<iframe src="http://docs.google.com/gview?url=<?php echo Yii::app()->getBaseUrl('true'); ?>/course_assets/powerpoint/<?php echo $course->powerpoint;?>&embedded=true" style="width:550px; height:450px;" frameborder="0"></iframe>
		</div>
	</div>

	<div style="display:none">
		<div id="powerpoint_viewer2">
			<iframe src="http://docs.google.com/gview?url=<?php echo Yii::app()->getBaseUrl('true'); ?>/course_assets/powerpoint/<?php echo $course->powerpoint_2;?>&embedded=true" style="width:550px; height:450px;" frameborder="0"></iframe>
		</div>
	</div>


	<div style="display:none">
		<div id="pre_test">
			<h1>Before you start...</h1>
			<p>Please take your time and answer all questions in this exam. A passing grade is <?php echo Course::getPassingPercentage($course->id); ?>%. You have unlimited attempts to pass.</p>
			<?php echo CHtml::link('Start the Exam', array('exam', 'id'=>$course->id),array('class'=>'green_button')); ?>
		</div>
	</div>


	<div style="display:none">
		<div id="pre_test_essay">
			<h1>Essay Question</h1>
			<p><?php echo $course->essay_question_content ?></p>
			<p><center><strong>Please submit your essay via email to <a href="mailto:<?php echo Yii::app()->params['notificationEmails'][0] ?>"><?php echo Yii::app()->params['notificationEmails'][0] ?></a></strong>.</center></p>
			<p><center><small>Once your essay has been graded, <br>you will receive a notification.</center></small></p>
		</div>
	</div>

</div> <!-- wrapper -->
