<?php

/**
 * This is the model class for table "offering_has_category".
 *
 * The followings are the available columns in table 'offering_has_category':
 * @property string $offering_id
 * @property string $course_category_id
 *
 * The followings are the available model relations:
 * @property CourseCategory $courseCategory
 * @property Offerings $offering
 */
class OfferingHasCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OfferingHasCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'offering_has_category';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('offering_id, course_category_id', 'required'),
			array('offering_id, course_category_id', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('offering_id, course_category_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseCategory' => array(self::BELONGS_TO, 'CourseCategory', 'course_category_id'),
			'offering' => array(self::BELONGS_TO, 'Offerings', 'offering_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'offering_id' => 'Offering',
			'course_category_id' => 'Course Category',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('offering_id',$this->offering_id,true);
		$criteria->compare('course_category_id',$this->course_category_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}