<?php

/**
 * This is the model class for table "course_category".
 *
 * The followings are the available columns in table 'course_category':
 * @property string $id
 * @property string $name
 *
 * The followings are the available model relations:
 * @property CourseHasCategory $courseHasCategory
 * @property OfferingHasCategory[] $offeringHasCategories
 */
class CourseCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CourseCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'course_category';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name', 'required'),
			array('name', 'length', 'max'=>60),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseHasCategory' => array(self::HAS_ONE, 'CourseHasCategory', 'course_category_id'),
			'offeringHasCategories' => array(self::HAS_MANY, 'OfferingHasCategory', 'course_category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('name',$this->name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}


	public static function getCourseCategoryId($course_id) {
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('course_category_id');
		$cmd->from('course_has_category');
		$cmd->where('course_id='.$course_id);
		$category_id = $cmd->queryScalar();
		return $category_id;
	}

}