<?php

class EvaluationController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Evaluation;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Evaluation']))
		{
			$model->attributes=$_POST['Evaluation'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Evaluation']))
		{
			$model->attributes=$_POST['Evaluation'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex($id)
	{

		$this->layout='main';

		$offerings = Offerings::model()->findAll();
		$course=Course::model()->with('courseHasCategories')->findByPk($id);

		$model = new Evaluation;

		if(isset($_POST['Evaluation'])) {
			$model->attributes = $_POST['Evaluation'];
			$model->course_id = $id;
			if($model->save()) {
				

				// Send Email to admins
					
					$variables[0] = $model->student_name;
					$variables[1] = date("F j, Y, g:i a", time());
					$variables[2] = $model->question_1;
					$variables[3] = $model->question_2;
					$variables[4] = $model->question_3;
					$variables[5] = $model->question_4;
					$variables[6] = $model->question_5;
					$variables[7] = $model->rating;
					$variables[8] = $course->name;
					$this->SendMail('cjp@fortriscorp.com', 'Training Course Evaluation Submission', 'course_evaluation', $variables);
					

					// Change course access to evaluated
					$cmd = Yii::app()->db->createCommand();
					$cmd->update('user_course_access', 
							array('evaluated'=>1), 
							array('AND','user_id = :user_id','course_id = :course_id'),
							array(':user_id'=>Yii::app()->user->id, ':course_id'=>$id)
					);

				$this->redirect(array('course/'.$id));
			}
		}


		// Check if user has access
		if(!$this->checkCourseAccess($id)) {
			$this->redirect(array('dashboard/noaccess'));
		}

		


		// Get attempts
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('grade');
		$cmd->from('exam_results');
		$cmd->where('user_id='.Yii::app()->user->id);
		$cmd->andWhere('course_id='.$id);
		$attempts = $cmd->query(); 


		// Render view view
		$this->render('index',array(
								'offerings' => $offerings,
								'course' => $course,
								'attempts' => $attempts,
								'model' => $model,
								));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Evaluation('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Evaluation']))
			$model->attributes=$_GET['Evaluation'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Evaluation the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Evaluation::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Evaluation $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='evaluation-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
