<?php

class DashboardController extends Controller
{	


	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	public function accessRules()
	{
		
	
		return array(
			array('allow',
				'actions'=>array('index','error'),
				'users'=>array('@'),
			),

			array('allow',
				'actions'=>array('error','noaccess'),
				'users'=>array('*'),
			),

			// And so on.
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}


	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}


	public function actionNoAccess()
	{
				$this->render('no_access');
	}


	public function actionIndex()
	{
		$this->layout='main';
		// renders the view file 'protected/views/app/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		
		// Get amount of CEU's
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('CEU_count');
		$cmd->from('user');
		$cmd->where('id='.Yii::app()->user->id);
		$ceu_count = $cmd->queryScalar();

		// Get all courses that user is registered in
		$courses=UserCourseAccess::model()->with('course')->findAll('user_id='.Yii::app()->user->id);
		

		// Get all courses
		$allCourses = Course::model()->findAll(array('condition'=>'in_person = 0'));
		
		// Get top level course offerings
		$offerings = Offerings::model()->findAll();


		$register_model=new RegisterForm;


		$this->render('index',array(
								'ceu_count'=>$ceu_count,
								'register_model' => $register_model,
								'courses' => $courses,
								'allCourses' => $allCourses,
								'offerings' => $offerings,
								'offering_id' => $offering_id=NULL));
	}



}