<?php
/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends CController
{
	
	/**
	 * @var array context menu items. This property will be assigned to {@link CMenu::items}.
	 */
	public $menu=array();
	/**
	 * @var array the breadcrumbs of the current page. The value of this property will
	 * be assigned to {@link CBreadcrumbs::links}. Please refer to {@link CBreadcrumbs::links}
	 * for more details on how to specify this property.
	 */
	public $breadcrumbs=array();


	// Check if user has access to the given course
	public function checkCourseAccess($course_id) {
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('COUNT(*)');
		$cmd->from('user_course_access');
		$cmd->where('user_id='.Yii::app()->user->id);
		$cmd->andWhere('course_id='.$course_id);
		$num = $cmd->queryScalar();
		return $num;
	}


	// Get the status of the given course
	public function getCourseStatus($course_id) {
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('status');
		$cmd->from('user_course_access');
		$cmd->where('user_id='.Yii::app()->user->id);
		$cmd->andWhere('course_id='.$course_id);
		$result = $cmd->queryRow();
		return $result['status'];
	}


	public function SendMail($userMail, $subject, $template, $variables)
    {   
        $message            = new YiiMailMessage;
        $message->view 		 = $template;
        $params              = array('variables'=>$variables);
        $message->subject    = $subject;
        $message->setBody($params, 'text/html');                
        $message->addTo($userMail);
        $message->from = 'info@addictionacademy.com';   
        Yii::app()->mail->send($message);       
    }


	public function behaviors() {
		return array(
			'BodyClassBehavior' => array( 
				'class' => 'ext.BodyClassBehavior.BodyClassBehavior'
				),
			);
	}
}