<?php

/**
 * This is the model class for table "settings".
 *
 * The followings are the available columns in table 'settings':
 * @property string $id
 * @property string $access_code
 * @property string $staff_type_select
 * @property string $footer_column_1
 * @property string $footer_column_2
 */
class Setting extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Setting the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'settings';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('access_code, staff_type_select', 'length', 'max'=>60),
			array('footer_column_1, footer_column_2', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, access_code, staff_type_select, footer_column_1, footer_column_2', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'access_code' => 'Access Code',
			'staff_type_select' => 'Staff Type Select',
			'footer_column_1' => 'Footer Column 1',
			'footer_column_2' => 'Footer Column 2',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('access_code',$this->access_code,true);
		$criteria->compare('staff_type_select',$this->staff_type_select,true);
		$criteria->compare('footer_column_1',$this->footer_column_1,true);
		$criteria->compare('footer_column_2',$this->footer_column_2,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}