<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'AppController'.
 */
class RegisterForm extends CFormModel
{
	public $cc_num;
	public $cc_name;
	public $promo_code;
	public $course_id;

	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
		return array(
			// username and password are required
			array('course_id', 'required'),
			array('promo_code', 'checkPromoCode')
		);
	}

	public function checkPromoCode() 
	{
		$cmd = Yii::app()->db->createCommand();
		$cmd->select('promo_code');
		$cmd->from('course');
		$cmd->where('id='.$this->course_id);
		$course_promo_code = $cmd->queryScalar(); 

		if($course_promo_code) {
			if($course_promo_code != $this->promo_code) {
				$this->addError('promo_code','Incorrect Promo Code.');
			}
		} 
		
	}


	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
			'pass'=>'Password',
			'email'=>'Email',
			'rememberMe'=>'Remember me next time',
		);
	}

}
