<?php

class AccountController extends Controller
{	


	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array('ext.booster.filters.BootstrapFilter - login,logout,create,forgotpassword,index')
		);
	}

	public function accessRules()
	{
		
	
		return array(
			array('allow',
				'actions'=>array('login','logout','create','forgotpassword'),
				'users'=>array('*'),
			),

			array('allow',
				'actions'=>array('index'),
				'users'=>array('@'),
			),

			array('allow',
					'actions'=>array('admin','update','manualcreate','delete', 'resetallpasswords', 'export', 'exportuserreport'),
					'users'=>array('@'),
					'expression'=>'Yii::app()->user->access_level==1 || Yii::app()->user->access_level==2',
			),

			// And so on.
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}




	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
		$model=new LoginForm;

		//Check if user is logged in and redirect
		if (!Yii::app()->user->getIsGuest()) {
		    $this->redirect(array('dashboard/'));
		}

		// collect user input data
		if(isset($_POST['LoginForm']))
		{
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
				$this->redirect(array('dashboard/'));
				//$this->redirect(Yii::app()->user->returnUrl);
		}
		// display the login form
		$this->render('login',array('model'=>$model));
	}


	public function actionCreate()
	{
	
		//Check if user is logged in and redirect
		if (!Yii::app()->user->getIsGuest()) {
		    $this->redirect(array('dashboard/'));
		}

		$model=new User('create');
		

		if(isset($_POST['User'])) {
			$model->attributes = $_POST['User'];
			
			// Temporarily give access without confirmation code
			$model->confirmed = 1;
			
			if ($model->save()) {
				//Flash
				// Yii::app()->user->setFlash('success', "			
				// <h3>Almost Finished!</h3>
				// <p>Before you can log in, you'll need to confirm your email address. An email has been sent to ".$model->email." with a confirmation link.</p>
				// ");

				Yii::app()->user->setFlash('success', "			
				<h3>Account Created!</h3>
				<p>You can now login with your account information.</p>
				");

				$this->redirect(array('account/login'));
			}
		}
		

		$this->render('create',array('model'=>$model));


	}




	public function actionManualCreate()
	{
		$this->layout='admin';

		$model=new User('create');

		// Set staff type to empty array
		$model->staff_type = array();



		if(isset($_POST['User'])) {
			$model->attributes = $_POST['User'];

			// Assign necessary variables to save
			$model->confirmed = 1;
			$model->access_code = User::getAccessCode();
			$model->email_compare = $model->email;
			$model->staff_type = NULL;

			if ($model->save())
				$this->redirect(array('update','id'=>$model->id));

		}


		//Get Course Categories
		$courseCategories=CourseCategory::model()->findAll();

		$this->render('update',array(
			'model'=>$model,
			'categories'=>$courseCategories,
		));

	}





	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}



	public function actionAdmin()
	{
		$this->layout='admin';

		$model=new User('search');
		$model->unsetAttributes();  // clear any default values

		

		if(isset($_GET['User'])) {
			$model->attributes=$_GET['User'];
		}

		if(isset($_GET['active']) && $_GET['active']==0) {
			$model->active = 0;
		} else {
			$model->active = 1;
		}
		
		$this->render('admin',array(
			'model'=>$model,
		));
	}



	public function actionUpdate($id = NULL)
	{

		$this->layout='admin';


		if(isset($id)) :
			$model=$this->loadModel($id);
		else :
			$model=new User('create');
		endif;


		// Save updated user data
		if(isset($_POST['User']))
		{
			$model->attributes=$_POST['User'];

			// Check if course categories
				if(isset($_POST['staff_type'])) {
					$model->staff_type = serialize($_POST['staff_type']);	
				} else {
					$model->staff_type = NULL;
				}//End Check if course categories / offering are set and save

			// var_dump($_POST['User']);
			if($model->save())
				$this->redirect(array('update','id'=>$model->id));

		}


		// Check if manual course progress updates and save
		if(isset($_POST['UserCourseAccess']))
		{
			// Check if exists
			if($_POST['UserCourseAccess']['id']) {
				$courseProgressModel=UserCourseAccess::model()->findByPk($_POST['UserCourseAccess']['id']);
			} else {
				$courseProgressModel=new UserCourseAccess();
			}

			// Load attributes
			$courseProgressModel->essay_grade=$_POST['UserCourseAccess']['essay_grade'];
			$courseProgressModel->user_id = $id;
			$courseProgressModel->time_completed = time();

			// Confirm date was entered
			// if($courseProgressModel->essay_grade) {

				// Convert date to proper format
				// $date_array = explode('/', $courseProgressModel->time_completed);
				// $courseProgressModel->time_completed = mktime(0, 0, 0, $date_array[0], $date_array[1], $date_array[2]);
			
				if($courseProgressModel->save())
					$this->redirect(array('update','id'=>$model->id));
			// }
			
		}

		// Check if new training is set and save
		if(isset($_POST['Training'])) {

			$newTraining=new Training();
			$newTraining->attributes=$_POST['Training'];
			$newTraining->user_id = $model->id;
			if($newTraining->save())
					$this->redirect(array('update','id'=>$model->id));
		}


		//Get Course Categories
		$courseCategories=CourseCategory::model()->findAll();


		//Get all courses
		$courseModel=Course::model()->findAll();


		//Get all trainings
		$trainings=Training::model()->findAll(array('condition'=>'user_id='.$model->id));

		// Create new training for form
		$newTraining=new Training();



		$this->render('update',array(
			'model'=>$model,
			'courseModel'=>$courseModel,
			'trainings'=>$trainings,
			'newTraining'=>$newTraining,
			'categories'=>$courseCategories
		));
	}



	public function actionForgotPassword($code = NULL, $id = NULL)
	{


		// Check if id and code are set and display reset password form
		if($code && $id) {

			// Check if user email exists and if code provided matches
			if(($model=User::model()->findByPk($id)) && ($model->confirmation_code == $code)) {
				
				//Check if user has submitted new password
				if(isset($_POST['save']))
				{
					$model->attributes=$_POST['User'];

					if($model->staff_type) {
						$model->staff_type = serialize($model->staff_type);
					} else {
						$model->staff_type = NULL;	
					}
					

					if($model->save()) {
						//Set Flash
						Yii::app()->user->setFlash('confirmed', "			
							<h3>Password Reset Complete</h3>
							<p>You may now login with your new password.</p>
							");
						$this->redirect(array('account/login'));
					}

					
				}

				//Render password reset field
				$this->render('password_reset_step2',array('model'=>$model));

				
			} else {
			
				$this->redirect(array('account/login'));
			}

		}



		//Check if user has submitted email for password reset
		if(isset($_POST['reset']))
		{

			if($model=User::model()->findByAttributes(array('email'=>$_POST['User']['email']))) {

			//Send Email
					$this->SendMail($model->email, 'The Academy for Addiction Professionals | Password Reset', 'password_reset', $model);

			//Set Flash
				Yii::app()->user->setFlash('confirmed', "			
					<h3>Password Reset Email Sent</h3>
					<p>An email has been sent to ".$model->email." that contains a link to reset your password.</p>
					");

			}

			$this->redirect(array('account/login'));
		}

		//If ID and code is not set, display forgot password field
		if(!$id && !$code) {
			$model=new User;
			$this->render('password_reset',array('model'=>$model));

		}
	
	}


	public function actionResetAllPasswords() {

		$users=User::model()->findAll();

		foreach ($users as $user) {
			if($user->access_level == 0) {
				$single_user=User::model()->findByPk($user->id);
				$single_user->pass = hash_hmac('sha256', 'dhope1234', Yii::app()->params['encryptionKey']); 
				$single_user->staff_type = serialize($single_user->staff_type);
				echo $single_user->lname.'-'.$single_user->pass.'<br>';
				$single_user->save();
			}
			
		}


	}



	public function actionExport()
	{
		
		header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="User-Export-'.date('m-d-Y').'.csv"');

		$active = $_GET['active'];

		$list[] = 'User Name | Email | Hire Date | Staff Type | Compliancy | Compliant Courses | Non-Compliant Courses | In Progress Courses';
		echo $active;
		if($active == 1)
			$users = User::model()->findAll(array('condition' => 'active = 1', 'order'=>'lname ASC'));
        
        if($active == 0)
			$users = User::model()->findAll(array('condition' => 'active = 0', 'order'=>'lname ASC'));
        

        foreach ($users as $user) {
        	
        	$name = $user->lname.', '.$user->fname;
        	$hire_date =  date('F, j Y', strtotime($user->join_date));

        	// Get staff type
        	$staff_type_list = ' ';
        	if($user->staff_type) {
	        	foreach ($user->staff_type as $staff_type) {
	        		switch ($staff_type) {
	        			case 1: $staff_type_list .= 'All Staff ';  break;
	        			case 2: $staff_type_list .= 'Direct Care ';  break;
	        			case 3: $staff_type_list .= 'BHT ';  break;
	        		}
	        	}
	        }

	        // Get compliant / uncompliant courses
	        $noncompliant = '';
	        $compliant = '';
	        $progress = '';

	        $courses = Course::model()->findAll();
	        foreach ($courses as $course) {
	        	$compliance = User::checkCompliance($user->id, $course->id);
	        	$results = UserCourseAccess::checkStatus($course->id, $user->id);

	        	// Not compliant
	        	if(isset($compliance) && $compliance['compliant'] != 1) {
					$noncompliant .= $course->name.', ';
				}

				// Compliant
	        	if($results['status'] == 'Completed' && $compliance['compliant'] != 0) {
					$compliant .= $course->name.', ';
				}

				// Compliant
	        	if($results['status'] == 'In Progress') {
					$progress .= $course->name.', ';
				}

	        } //end foreach

	        // Check overall compliancy
	        $compliancy = NULL;
	        if(User::checkFullCompliance($user->id))
	        	$compliancy = 'Compliant';


        	$list[] = $name.'|'. $user->email.'|'. $hire_date.'|'. $staff_type_list.'|'.$compliancy.'|'.$compliant.'|'.$noncompliant.'|'.$progress;
        	
        	// echo $name . '<br>';

        }



        $output = fopen('php://output', 'w');

        	// Create CSV
        foreach ($list as $line) {
        	fputcsv($output, explode('|',$line));
        }


	}



	public function actionExportUserReport($id)
	{
		
		header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="User-Export-'.date('m-d-Y').'.csv"');


		$list[] = 'Course Name | Completion Date';
		
        $courses = Course::model()->findAll();
        $user = User::model()->findByPk($id);

        foreach ($courses as $key => $course) {


        	$compliance = User::checkCompliance($user->id, $course->id);
        	$results = UserCourseAccess::checkStatus($course->id, $user->id);

        	

        	// var_dump($results);
        	$completion_date = NULL;
        	if($results && $results['time_completed'])
        		$completion_date = date('m-d-Y', $results['time_completed']);

        	$list[] = $course->name.'|'.$compliancy.'|'.$completion_date;

        } //endforeach coursemodel



        $output = fopen('php://output', 'w');

        	// Create CSV
        foreach ($list as $line) {
        	fputcsv($output, explode('|',$line));
        }


	}



	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}



	public function loadModel($id)
	{
		$model=User::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}




}