<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'Addiction Academy Learning Application',
	'defaultController'=>'dashboard',




	// preloading 'log' component
	'preload'=>array('log'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
		'application.helpers.*',
		'application.extensions.yii-mail.YiiMailMessage',
	),

	'modules'=>array(
		// uncomment the following to enable the Gii tool
		
		'gii'=>array(
			'class'=>'system.gii.GiiModule',
			'password'=>'sheppard1',
			// If removed, Gii defaults to localhost only. Edit carefully to taste.
			'ipFilters'=>array('127.0.0.1','::1'),
		),
		
	),

	// application components
	'components'=>array(
		'bootstrap' => array(
			'class' => 'ext.booster.components.Bootstrap',
		),
		
		'user'=>array(
			// enable cookie-based authentication
			'loginUrl'=>array('account/login'),
			'allowAutoLogin'=>true,
			'returnUrl' => array('/index'),
		),
		// uncomment the following to enable URLs in path-format
		
		'urlManager'=>array(
			'urlFormat'=>'path',
			'showScriptName'=>false,
			'rules'=>array(
				'account/login/<id:\d+>/<code:\d+>'=>'account/login',
				'account/forgotpassword/<id:\d+>/<code:\d+>'=>'account/forgotpassword',


				'course/category/<offering_id:\d+>'=>'course/category',
				'course/category/<offering_id:\d+>/<category_id:\d+>'=>'course/category',
				'course/category/<offering_id:\d+>/<category_id:\d+>/<course_id:\d+>'=>'course/category',

				'<controller:\w+>/<id:\d+>'=>'<controller>/index',
				'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',

				'course/review/<id:\d+>/<attempt:\d+>'=>'course/review',
			),
		),
		
		// 'db'=>array(
		// 	'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
		// ),
		// uncomment the following to use a MySQL database
		
		'db'=>array(
			'connectionString' => 'mysql:host=localhost;dbname=honeylake_school',
			'emulatePrepare' => true,
			'username' => 'john',
			'password' => 'Or1g1nal!',
			'charset' => 'utf8',
		),
		
		'errorHandler'=>array(
			// use 'site/error' action to display errors
			'errorAction'=>'dashboard/error',
		),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
				// uncomment the following to show log messages on web pages
				/*
				array(
					'class'=>'CWebLogRoute',
				),
				*/
			),
		),

		//Yii Mailer Code
		'mail' => array(
	                'class' => 'ext.yii-mail.YiiMail',
	                'transportType'=>'smtp',
	                'transportOptions'=>array(
	                        'host'=>'20ae.websitewelcome.com',
	                        'username'=>'courses@addictionacademy.com',
	                        'password'=>'courses123',
	                        'port'=>'465',
	                        'encryption'=>'ssl',                       
	                ),
	                'viewPath' => 'application.views.mail',             
	    ),
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'dbell@honeylake.clinic',
		'encryptionKey' => 'Qw282b6h91b57qh',
		'notificationEmails'=>array('dbell@honeylake.clinic'),
	),
);