<?php
/* @var $this PageController */
/* @var $model Page */

$baseUrl = Yii::app()->baseUrl; 

// initiate FPDI
$pdf = new FPDI();

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// add a page
$pdf->AddPage('L');

// set the source file
$pdf->setSourceFile("course_assets/blank-certificate.pdf");
// import page 1
$tplIdx = $pdf->importPage(1);
// use the imported page and place it at point 10,10 with a width of 100 mm
$pdf->useTemplate($tplIdx, 18, 0, 252);


$pdf->SetTitle('TCPDF Example 001');

// now write some text above the imported page
$pdf->SetFont('Helvetica','',18);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetXY(0, 95);
$pdf->Cell(0, 0, Yii::app()->user->fname.' '.Yii::app()->user->lname, 0, 0, 'C');


// now write some text above the imported page
$pdf->SetFont('Helvetica','',18);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetXY(0, 119);
$pdf->Cell(0, 0, $model->name.' ('.$model->ceu_credit.' hours)', 0, 0, 'C');


// now write some text above the imported page
$pdf->SetFont('Helvetica','',11);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetXY(149.5, 132.6);
$pdf->Cell(0, 0, $model->ceu_credit, 0, 0, 'C');

$filename = Yii::app()->user->fname.' '.Yii::app()->user->lname;
$filename .= '_'.$model->name;
$filename = preg_replace('/[^a-zA-Z0-9_.-]/', '_', $filename);

$save_url = 'course_assets/certificates/'.$filename.'.pdf';

$pdf->Output();
$pdf->Output($save_url, 'F');



?>

