<?php
/* @var $this AccountController */
/* @var $model User */

Yii::app()->clientScript->registerCoreScript('jquery');

?>

<div class="wrapper">


<div id="register_form" class="account_form">

<h1>Create Your Account</h1>
<h2>Tell us a little about yourself.</h2>

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'registration-form',
	'enableAjaxValidation'=>false,
	'stateful'=>true,
)); 

$months = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
?>

	<?php echo $form->errorSummary($model); ?>


	<div class="row left">
		<?php echo $form->labelEx($model,'fname'); ?>
		<?php echo $form->textField($model,'fname',array('size'=>60,'maxlength'=>60, 'class'=>'text')); ?>
		<?php echo $form->error($model,'fname'); ?>
	</div>

	<div class="row right">
		<?php echo $form->labelEx($model,'lname'); ?>
		<?php echo $form->textField($model,'lname',array('size'=>60,'maxlength'=>60, 'class'=>'text')); ?>
		<?php echo $form->error($model,'lname'); ?>
	</div>
	
	<div class="clear"></div>

	<div class="row">
		<?php echo $form->labelEx($model,'pass'); ?>
		<?php echo $form->passwordField($model,'pass',array('size'=>60,'maxlength'=>64, 'class'=>'text')); ?>
		<?php echo $form->error($model,'pass'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'email'); ?>
		<?php echo $form->textField($model,'email',array('size'=>60,'maxlength'=>60, 'class'=>'text')); ?>
		<?php echo $form->error($model,'email'); ?>
	</div>
	
	<div class="row">
		<?php echo $form->labelEx($model,'email_compare'); ?>
		<?php echo $form->textField($model,'email_compare',array('size'=>60,'maxlength'=>60, 'class'=>'text')); ?>
		<?php echo $form->error($model,'email_compare'); ?>
	</div>

	<div class="row">
		<?php if(User::model()->getStaffTypes()) { ?>
			<?php echo $form->labelEx($model,'staff_type'); ?>
			<?php echo $form->dropDownList($model, 'staff_type', User::model()->getStaffTypes(), array('empty' => 'Please Select')); ?>
			<?php echo $form->error($model,'staff_type'); ?>
		<?php } ?>
	</div>

			
	

	<div class="row">
		<?php if(User::model()->getAccessCode()) { ?>
			<?php echo $form->labelEx($model,'access_code'); ?>
			<?php echo $form->textField($model,'access_code',array('size'=>60,'maxlength'=>60, 'class'=>'text')); ?>
			<?php echo $form->error($model,'access_code'); ?>
		<?php } ?>
	</div>

	
	<div class="row buttons">
		<?php echo CHtml::submitButton("Create Account",array('name'=>'step2','class'=>'submit')); ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->

</div> <!-- wrapper -->



