<?php

/**
 * This is the model class for table "evaluation".
 *
 * The followings are the available columns in table 'evaluation':
 * @property string $id
 * @property integer $date
 * @property string $student_name
 * @property string $question_1
 * @property string $question_2
 * @property string $question_3
 * @property string $question_4
 * @property string $question_5
 * @property integer $rating
 */
class Evaluation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Evaluation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}



	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'evaluation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, rating, course_id', 'required'),
			array('date, rating, course_id', 'numerical', 'integerOnly'=>true),
			array('student_name', 'length', 'max'=>60),
			array('question_1, question_2, question_3, question_4, question_5', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, date, student_name, question_1, question_2, question_3, question_4, question_5, rating', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'student_name' => 'Student Name',
			'question_1' => 'What did you enjoy most about the course, which aspects?',
			'question_2' => 'What did you enjoy the least about the course, which aspects?',
			'question_3' => 'What could have been done differently to enhance the online experience?',
			'question_4' => 'Was the course content stimulating?',
			'question_5' => 'What type of CEU’s or courses would you like to see in the future?',
			'rating' => 'Rate the Course Content',
		);
	}


	public function beforeValidate()
	{
		$this->date = time();
		return parent::beforeValidate();
	}



	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('date',$this->date);
		$criteria->compare('student_name',$this->student_name,true);
		$criteria->compare('question_1',$this->question_1,true);
		$criteria->compare('question_2',$this->question_2,true);
		$criteria->compare('question_3',$this->question_3,true);
		$criteria->compare('question_4',$this->question_4,true);
		$criteria->compare('question_5',$this->question_5,true);
		$criteria->compare('rating',$this->rating);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}